/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.creeperhost.common;

import java.util.regex.Pattern;
import net.creeperhost.creeperhost.common.IOrderValidation;

public class RegexValidator
implements IOrderValidation {
    private Pattern pattern;
    private String failMessage;

    public RegexValidator(String regex, String failMessage) {
        this.pattern = Pattern.compile(regex);
        this.failMessage = failMessage;
    }

    @Override
    public boolean validationCheckAtPhase(IOrderValidation.ValidationPhase phase) {
        return phase.equals((Object)IOrderValidation.ValidationPhase.CHANGED);
    }

    @Override
    public boolean isValid(String string) {
        return this.pattern.matcher(string).matches();
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public String getValidationMessage() {
        return this.failMessage;
    }

    @Override
    public String getName() {
        return "RegexValidator";
    }
}

