/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json.items;

import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.commons.lang3.StringUtils;
import tterrag.customthings.common.config.json.IHasMaterial;
import tterrag.customthings.common.config.json.items.ItemType;
import tterrag.customthings.common.item.ICustomRepair;
import tterrag.customthings.common.item.ItemCustomAxe;
import tterrag.customthings.common.item.ItemCustomHoe;
import tterrag.customthings.common.item.ItemCustomPickaxe;
import tterrag.customthings.common.item.ItemCustomShovel;
import tterrag.customthings.common.item.ItemCustomSword;

public class ToolType
extends ItemType
implements IHasMaterial {
    public String[] tools = new String[]{"PICKAXE", "SHOVEL", "AXE", "SWORD", "HOE"};
    public int level = 1;
    public int durability = 500;
    public float efficiency = 4.0f;
    public float damage = 1.0f;
    public int enchantability = 5;
    public String material = "null";
    private transient Item pickaxe;
    private transient Item shovel;
    private transient Item axe;
    private transient Item sword;
    private transient Item hoe;
    private transient ItemStack repairMat;
    public static final List<ToolType> types = new ArrayList<ToolType>();

    public List<ToolClass> getToolClasses() {
        ArrayList<ToolClass> list = new ArrayList<ToolClass>();
        for (String s : this.tools) {
            list.add(ToolClass.valueOf(s.toUpperCase()));
        }
        return list;
    }

    public Item.ToolMaterial getToolMaterial() {
        return Item.ToolMaterial.valueOf((String)this.name);
    }

    @Override
    public void register() {
        super.register();
        EnumHelper.addToolMaterial((String)this.name, (int)this.level, (int)this.durability, (float)this.efficiency, (float)this.damage, (int)this.enchantability);
        for (ToolClass clazz : this.getToolClasses()) {
            switch (clazz) {
                case PICKAXE: {
                    this.pickaxe = this.instantiate(clazz);
                    GameRegistry.registerItem((Item)this.pickaxe, (String)clazz.getUnlocName(this.name));
                    this.addOreDictNames(new ItemStack(this.pickaxe, 1, Short.MAX_VALUE));
                    break;
                }
                case AXE: {
                    this.axe = this.instantiate(clazz);
                    GameRegistry.registerItem((Item)this.axe, (String)clazz.getUnlocName(this.name));
                    this.addOreDictNames(new ItemStack(this.axe, 1, Short.MAX_VALUE));
                    break;
                }
                case HOE: {
                    this.hoe = this.instantiate(clazz);
                    GameRegistry.registerItem((Item)this.hoe, (String)clazz.getUnlocName(this.name));
                    this.addOreDictNames(new ItemStack(this.hoe, 1, Short.MAX_VALUE));
                    break;
                }
                case SHOVEL: {
                    this.shovel = this.instantiate(clazz);
                    GameRegistry.registerItem((Item)this.shovel, (String)clazz.getUnlocName(this.name));
                    this.addOreDictNames(new ItemStack(this.shovel, 1, Short.MAX_VALUE));
                    break;
                }
                case SWORD: {
                    this.sword = this.instantiate(clazz);
                    GameRegistry.registerItem((Item)this.sword, (String)clazz.getUnlocName(this.name));
                    this.addOreDictNames(new ItemStack(this.sword, 1, Short.MAX_VALUE));
                }
            }
        }
        types.add(this);
    }

    @Override
    public void postInit() {
        this.repairMat = this.material.equals("null") ? null : ItemUtil.parseStringIntoItemStack((String)this.material);
    }

    private Item instantiate(ToolClass clazz) {
        try {
            return (Item)clazz.itemClass.getDeclaredConstructor(ToolType.class).newInstance(this);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError("Class " + clazz.itemClass.getName() + " must have a constructor that takes a ToolType object");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getUnlocName(ToolClass toolClass) {
        return toolClass.getUnlocName(this.name);
    }

    public String getIconName(ToolClass toolClass) {
        return "customthings".toLowerCase() + ":" + this.getUnlocName(toolClass);
    }

    public Item getItem(ToolClass toolClass) {
        switch (toolClass) {
            case PICKAXE: {
                return this.pickaxe;
            }
            case AXE: {
                return this.axe;
            }
            case HOE: {
                return this.hoe;
            }
            case SHOVEL: {
                return this.shovel;
            }
            case SWORD: {
                return this.sword;
            }
        }
        return null;
    }

    public boolean hasItem(ToolClass toolClass) {
        return this.getItem(toolClass) != null;
    }

    @Override
    public ItemStack getRepairMat() {
        return this.repairMat;
    }

    public static enum ToolClass {
        PICKAXE(ItemCustomPickaxe.class),
        SHOVEL(ItemCustomShovel.class),
        AXE(ItemCustomAxe.class),
        SWORD(ItemCustomSword.class),
        HOE(ItemCustomHoe.class);

        public final Class<? extends ICustomRepair<ToolType>> itemClass;

        private ToolClass(Class<? extends ICustomRepair<ToolType>> itemClass) {
            this.itemClass = itemClass;
        }

        public String getUnlocName(String base) {
            return base + StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

