/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.block;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import tterrag.customthings.common.block.IBlockCustom;
import tterrag.customthings.common.config.json.BlockType;

public class BlockProxy<T extends Block>
implements IBlockCustom {
    public final BlockType[] types;
    private final T block;
    private final BlockType.BlockData data;
    private final int maxTypes;
    private final Random rand = new Random();
    @SideOnly(value=Side.CLIENT)
    private IIcon[][] icons;

    public BlockProxy(T block, BlockType.BlockData data, int maxTypes) {
        this.block = block;
        this.data = data;
        this.maxTypes = maxTypes;
        this.types = new BlockType[maxTypes];
    }

    public static <T extends Block> BlockProxy<T> dummy() {
        return new BlockProxy<Object>(null, null, 1);
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.getMaxTypes(); ++i) {
            if (this.getTypes()[i] == null) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister register) {
        this.icons = new IIcon[this.getMaxTypes()][6];
        for (int i = 0; i < this.types.length; ++i) {
            BlockType type = this.types[i];
            if (type == null) continue;
            if (type.textureMap == null) {
                this.icons[i][0] = register.func_94245_a("customthings".toLowerCase() + ":" + type.name);
                continue;
            }
            for (int j = 0; j < type.textureMap.length; ++j) {
                String tex = type.textureMap[j];
                this.icons[i][j] = register.func_94245_a("customthings".toLowerCase() + ":" + tex);
            }
        }
    }

    public IIcon getIcon(int side, int meta) {
        return this.getType((int)meta).textureMap == null ? this.icons[meta % this.getMaxTypes()][0] : this.icons[meta % this.getMaxTypes()][side];
    }

    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        return this.getIcon(side, world.func_72805_g(x, y, z));
    }

    public boolean isOpaqueCube() {
        return this.block == null ? true : this.getData().isOpaque();
    }

    public boolean isToolEffective(String tool, int metadata) {
        BlockType type = this.getType(metadata);
        return type.toolType.isEmpty() ? false : tool.equals(type.toolType);
    }

    public String getHarvestTool(int metadata) {
        BlockType type = this.getType(metadata);
        return type == null || type.toolType.isEmpty() ? null : type.toolType;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        BlockType type = this.getType(meta);
        ItemStack held = player.func_70694_bm();
        int harvestLevel = this.getHarvestLevel(meta);
        if (type.toolType.isEmpty() || held == null) {
            return ForgeHooks.canHarvestBlock(this.block, (EntityPlayer)player, (int)meta);
        }
        return held.func_77973_b().getHarvestLevel(held, this.getHarvestTool(meta)) >= harvestLevel && held.func_77973_b().getToolClasses(held).contains(type.toolType);
    }

    public int getHarvestLevel(int metadata) {
        BlockType type = this.getType(metadata);
        return type == null ? 0 : type.harvestLevel;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        BlockType type = this.getType((IBlockAccess)world, x, y, z);
        return type == null ? this.block.func_149712_f(world, x, y, z) : type.hardness;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        BlockType type = this.getType((IBlockAccess)world, x, y, z);
        return type == null ? this.block.func_149638_a(par1Entity) : type.resistance;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        BlockType type = this.getType(metadata);
        return type == null || type.drops.length == 0 ? Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(this.block, 1, metadata)}) : type.getStackDrops();
    }

    public int damageDropped(int metadata) {
        return metadata;
    }

    public int getExpDrop(IBlockAccess world, int metadata, int fortune) {
        BlockType type = this.types[metadata];
        return type == null ? 0 : this.rand.nextInt(type.maxXp - type.minXp + 1) + type.minXp;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        BlockType type = this.getType(world, x, y, z);
        return type.lightLevel;
    }

    private BlockType getType(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.getType(meta);
    }

    @Override
    public void setType(BlockType type, int meta) {
        this.types[meta % this.types.length] = type;
    }

    @Override
    public BlockType getType(int meta) {
        return this.types[meta % this.types.length];
    }

    @Override
    public BlockType getType(ItemStack stack) {
        return this.types[stack.func_77960_j() % this.types.length];
    }

    @Override
    public BlockType[] getTypes() {
        return this.types;
    }

    @Override
    public BlockType.BlockData getData() {
        return this.data;
    }

    @Override
    public int getMaxTypes() {
        return this.maxTypes;
    }
}

