/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import openperipheral.adapter.property.IFieldManipulator;
import openperipheral.adapter.property.IIndexedFieldManipulator;
import openperipheral.adapter.property.IIndexedPropertyAccessHandler;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.ISinglePropertyAccessHandler;
import openperipheral.adapter.property.IndexedTypeInfo;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.adapter.property.SingleTypeInfo;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConverter;
import org.apache.commons.lang3.ArrayUtils;

public class MergedSetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final boolean singleNullable;
    private final IFieldManipulator singleManipulator;
    private final SingleTypeInfo singleTypeInfo;
    private final ISinglePropertyAccessHandler singleAccessHandler;
    private final boolean indexedNullable;
    private final IIndexedFieldManipulator indexedManipulator;
    private final IndexedTypeInfo indexedTypeInfo;
    private final IIndexedPropertyAccessHandler indexedAccessHandler;

    public MergedSetterExecutor(Field field, boolean singleNullable, IFieldManipulator singleManipulator, SingleTypeInfo singleTypeInfo, ISinglePropertyAccessHandler singleAccessHandler, boolean indexedNullable, IIndexedFieldManipulator indexedManipulator, IndexedTypeInfo indexedTypeInfo, IIndexedPropertyAccessHandler indexedAccessHandler) {
        this.field = field;
        this.singleNullable = singleNullable;
        this.singleManipulator = singleManipulator;
        this.singleTypeInfo = singleTypeInfo;
        this.singleAccessHandler = singleAccessHandler;
        this.indexedNullable = indexedNullable;
        this.indexedManipulator = indexedManipulator;
        this.indexedTypeInfo = indexedTypeInfo;
        this.indexedAccessHandler = indexedAccessHandler;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        if (args.length != 2) {
            if (args.length == 1) {
                Object value = args[0];
                Object target = PropertyUtils.getContents(owner, this.field);
                Type valueType = this.singleTypeInfo.getValueType(target);
                Object convertedValue = TypeConverter.nullableToJava(converter, this.singleNullable, value, valueType);
                this.singleAccessHandler.onSet(owner, target, this.field, convertedValue);
                this.singleManipulator.setField(owner, target, this.field, convertedValue);
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
            throw new IllegalArgumentException("This method must be called with one or two arguments");
        }
        Object value = args[0];
        Object key = args[1];
        Type keyType = this.indexedTypeInfo.keyType;
        Object convertedKey = converter.toJava(key, keyType);
        Preconditions.checkArgument((convertedKey != null ? 1 : 0) != 0, (String)"Failed to convert index to type %s", (Object[])new Object[]{keyType});
        Object target = PropertyUtils.getContents(owner, this.field);
        Type valueType = this.indexedTypeInfo.getValueType(target, convertedKey);
        Object convertedValue = TypeConverter.nullableToJava(converter, this.indexedNullable, value, valueType);
        this.indexedAccessHandler.onSet(owner, target, this.field, convertedKey, convertedValue);
        this.indexedManipulator.setField(owner, target, this.field, convertedKey, convertedValue);
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

