---
navigation:
  title: Energy Storage
  icon: greater_energy_card
  parent: index.md
  position: 030
categories:
  - megacells
item_ids:
  - mega_energy_cell
  - greater_energy_card
---

# MEGA Cells: Energy

It would be remiss, of course, for MEGA to not also provide any larger form of [energy](ae2:ae2-mechanics/energy.md)
storage, so thankfully that base is also covered here.

## Superdense Energy Cell

<BlockImage id="mega_energy_cell" scale="4" />

The *Superdense Energy Cell* holds 8 times as much energy as a <ItemLink id="ae2:dense_energy_cell" /> and 64 times as
much as a standard <ItemLink id="ae2:energy_cell" />, for a total of up to 12.8 *million* AE per cell. Perfect for those
especially large [Spatial IO](ae2:ae2-mechanics/spatial-io.md) setups and transfer operations requiring an immense
energy buffer, now in a more compact block space!

<RecipeFor id="mega_energy_cell" />

## Greater Energy Card

<ItemImage id="greater_energy_card" scale="3" />

Further still, the Superdense Energy Cell can be used to craft a more souped up version of the
<ItemLink id="ae2:energy_card" />, providing an even greater energy buffer to any wireless infrastructure such as
portable storage cells and [wireless terminals](ae2:items-blocks-machines/wireless_terminals.md). AE2's own such devices
will support it just as well as the regular Energy Card. However, the more demanding
[MEGA portable cells](storage.md#portable-cells) will support *only* the Greater Energy Card to increase their battery
capacity.

<RecipeFor id="greater_energy_card" />
