#version 150


// from #moj_import <fog.glsl>
vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    if (vertexDistance <= fogStart) {
        return inColor;
    }

    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;
    return vec4(mix(inColor.rgb, fogColor.rgb, fogValue * fogColor.a), inColor.a * (1.0 - fogValue));
}

// -----------------------------------------------

float saturate(float i) {
    return clamp(i, 0.0, 1.0);
}

float handleNoise(vec2 uv, float time, sampler2D source) {
    float timeFactor1 = time * 0.1;
    vec2 time1 = vec2(0.0, 0.2) * timeFactor1;
    vec2 time2 = vec2(0.0, -0.1) * timeFactor1;

    float noise1 = texture(source, uv + time1).x;
    float noise2 = texture(source, uv + time2).x;

    float result = saturate(smoothstep(0.155, 1.0, noise1) + smoothstep(0.352, 0.0, noise2));

    return saturate(smoothstep(-0.66, 1.55, result));
}

float centerDistance(vec2 uv) {
    return 1.0 - distance(uv, vec2(0.5));
}

float prepareHighlight(float dist, float noise) {
    float innerIntensity = 1.02;
    float distMult = dist * innerIntensity;

    return pow(distMult, 27.7) + saturate(pow(distMult, 70.1)) * noise * 7.46;
}

vec4 compositeColor(float dist, float noise, vec4 vertColor) {
    float outerIntensity = 1.12;
    float noiseMask = pow(dist * outerIntensity, 20.6);
    float noiseComposite = noise * noiseMask;
    vec4 color = vertColor * saturate(noiseComposite * 2.0);
    return clamp(color, vec4(0.0), vec4(1.0));
}


in vec4 vertexColor;
in float vertexDistance;
in vec2 texCoord0; //uv0

uniform sampler2D Sampler0; //noise texture

uniform float RenderTime;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

out vec4 fragColor;

void main()
{
    float noise = handleNoise(texCoord0, RenderTime * 10000.0, Sampler0);
    float point = centerDistance(texCoord0);
    float highlight = prepareHighlight(point, noise);
    vec4 color = compositeColor(point, noise, vertexColor);

    if (color.a < 0.000001) {
        discard;
    }
    vec3 result = clamp(color.rgb + highlight, 0.0, 1.0);

    fragColor = linear_fog(vec4(result, color.a), vertexDistance, FogStart, FogEnd, FogColor);
}