#version 150

// from #moj_import <fog.glsl>
vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    if (vertexDistance <= fogStart) {
        return inColor;
    }

    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;
    return vec4(mix(inColor.rgb, fogColor.rgb, fogValue * fogColor.a), inColor.a * (1 - fogValue));
}

// -----------------------------------------------

float remap(float t, vec2 inRange, vec2 outRange) {
    return outRange.x + (t - inRange.x) * (outRange.y - outRange.x) / (inRange.y - inRange.x);
}

vec3 rgb2hsv(vec3 c) {
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c) {
    c.x *= 2.0;
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}


in vec4 vertexColor;
in float vertexDistance;
in vec2 texCoord0; //uv0

uniform sampler2D Sampler0; //noise texture

uniform float RenderTime;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

out vec4 fragColor;


uniform float TimeFactor; // 600
uniform float BandPower; // 1
uniform float WhiskPower; //0.47
uniform float NoiseBandPower;// 1.0
uniform float OuterBandPower; // 3.45
uniform float InnerBandPower; // 7.24
uniform float NoiseMultiplier; // 1.43

uniform vec2 Time1; // 0.03, 0.05
uniform vec2 Time2; //-0.06,-0.1
uniform vec2 OuterNoiseStep; // 0.17, 0.0
uniform vec2 OuterBandStep; // 0.12, 0.03
uniform vec2 InnerBandStep; //0.05, 0
uniform vec2 NoiseCompositeStep; //-0.09, 1.75
uniform vec2 WhiskRemap; // 0.12, 0.34
uniform vec2 LimiterStep;// 0.5, 0.79
uniform vec2 UpperNoiseStep; // 0.11, 1
uniform vec2 LowerNoiseStep; //-0.12, 1
uniform vec2 CorrectionStep; //0.0, 0.8



void main() {
    float time = RenderTime * TimeFactor;
    vec2 timeFactor1 = vec2(time) * Time1/**vec2(0.03, 0.05)*/;
    vec2 timeFactor2 = vec2(time) * Time2/**vec2(-0.06, -0.1)*/;

    float upperNoise = smoothstep(UpperNoiseStep.x, UpperNoiseStep.y, texture(Sampler0, texCoord0 + timeFactor1).x);
    float lowerNoise = smoothstep(LowerNoiseStep.x, LowerNoiseStep.y, texture(Sampler0, texCoord0 + timeFactor2).x);

    float noiseComposite = clamp(upperNoise + lowerNoise, 0.0, 1.0) * NoiseMultiplier;


    float dist = distance(texCoord0.y, 0.5);
    float band = pow(dist, BandPower);

    float outerBandNoise = (pow(smoothstep(OuterNoiseStep.x, OuterNoiseStep.y, band), NoiseBandPower) * noiseComposite + pow(smoothstep(OuterBandStep.x, OuterBandStep.y, band), OuterBandPower)) * 0.5;
    float innerBand = pow(smoothstep(InnerBandStep.x, InnerBandStep.y, band), InnerBandPower);
    float whisk = clamp(remap(pow(band, WhiskPower) * noiseComposite, WhiskRemap, vec2(0.0, 1.0)), 0.0, 1.0);
    float edgeLimiter = smoothstep(LimiterStep.x, LimiterStep.y, 1.0 - dist);

    vec4 color = clamp(smoothstep(CorrectionStep.x, CorrectionStep.y, clamp(smoothstep(NoiseCompositeStep.x, NoiseCompositeStep.y, outerBandNoise) - whisk, 0.0, 1.0)) * vec4(hsv2rgb(vertexColor.rgb), vertexColor.a) * edgeLimiter + innerBand, vec4(0.0), vec4(1.0)) * edgeLimiter;

    if (color.a < 0.000001) {
        discard;
    }

    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
