/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.util.AEColor;
import appeng.client.render.BlockEntityRenderHelper;
import appeng.core.AppEng;
import appeng.hooks.ticking.TickHandler;
import appeng.items.parts.PartModels;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractMonitorPart;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.client.renderer.AAEBlockEntityRenderHelper;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.logic.ThroughputCache;
import net.pedroksl.advanced_ae.mixins.MixinAbstractMonitorPartAccessor;

public class ThroughputMonitorPart
extends AbstractMonitorPart
implements IGridTickable {
    @PartModels
    public static final ResourceLocation MODEL_OFF = AppEng.makeId((String)"part/storage_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = AppEng.makeId((String)"part/storage_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = AppEng.makeId((String)"part/storage_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = AppEng.makeId((String)"part/storage_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL});
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF});
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON});
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL});
    private final ThroughputCache cache = new ThroughputCache();
    protected double lastReportedValue = -1.0;
    protected String lastHumanReadableValue = "";
    private WorkRoutine workRoutine = WorkRoutine.SECOND;
    private WorkRoutine lastWorkRoutine = WorkRoutine.SECOND;
    private static final int positiveColor = AEColor.GREEN.mediumVariant;
    private static final int negativeColor = AEColor.RED.mediumVariant;

    public ThroughputMonitorPart(IPartItem<?> partItem) {
        super(partItem, false);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.writeToNBT(data, registries);
        data.putString("throughput", this.lastHumanReadableValue);
        data.putInt("routine", this.workRoutine.ordinal());
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.lastHumanReadableValue = data.getString("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.getInt("routine"));
    }

    public void writeToStream(RegistryFriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeDouble(this.lastReportedValue);
        data.writeUtf(this.lastHumanReadableValue);
        data.writeEnum((Enum)this.workRoutine);
    }

    public boolean readFromStream(RegistryFriendlyByteBuf data) {
        boolean needRedraw = super.readFromStream(data);
        long reportedValue = data.readLong();
        needRedraw |= (double)reportedValue != this.lastReportedValue;
        this.lastReportedValue = reportedValue;
        this.lastHumanReadableValue = data.readUtf();
        WorkRoutine routine = (WorkRoutine)data.readEnum(WorkRoutine.class);
        boolean bl = this.workRoutine != routine;
        this.workRoutine = routine;
        return needRedraw |= bl;
    }

    public void writeVisualStateToNBT(CompoundTag data) {
        super.writeVisualStateToNBT(data);
        data.putDouble("lastValue", this.lastReportedValue);
        data.putString("throughput", this.lastHumanReadableValue);
        data.putInt("routine", this.workRoutine.ordinal());
    }

    public void readVisualStateFromNBT(CompoundTag data) {
        super.readVisualStateFromNBT(data);
        this.lastReportedValue = data.getLong("lastValue");
        this.lastHumanReadableValue = data.getString("throughput");
        this.workRoutine = WorkRoutine.fromInt(data.getInt("routine"));
    }

    public boolean onUseItemOn(ItemStack heldItem, Player player, InteractionHand hand, Vec3 pos) {
        if (heldItem == ItemStack.EMPTY) {
            return super.onUseWithoutItem(player, pos);
        }
        if (heldItem.is(AAEItems.MONITOR_CONFIGURATOR.asItem())) {
            if (!this.isClientSide()) {
                this.cycleWorkRoutine();
            }
            return true;
        }
        return super.onUseItemOn(heldItem, player, hand, pos);
    }

    private void cycleWorkRoutine() {
        this.workRoutine = WorkRoutine.cycle(this.workRoutine);
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    @Nullable
    private AEKey getConfiguredItem() {
        return ((MixinAbstractMonitorPartAccessor)((Object)this)).getConfiguredItem();
    }

    protected void configureWatchers() {
        if (this.getConfiguredItem() != null) {
            this.updateState(this.getAmount(), TickHandler.instance().getCurrentTick());
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        } else {
            this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().sleepDevice(node));
        }
        super.configureWatchers();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDynamic(float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLightIn, int combinedOverlayIn) {
        if (this.isActive() && this.getConfiguredItem() != null) {
            MutableComponent text;
            poseStack.pushPose();
            BlockOrientation orientation = BlockOrientation.get((Direction)this.getSide(), (int)this.getSpin());
            poseStack.translate(0.5, 0.5, 0.5);
            BlockEntityRenderHelper.rotateToFace((PoseStack)poseStack, (BlockOrientation)orientation);
            poseStack.translate(0.0, 0.1, 0.5);
            BlockEntityRenderHelper.renderItem2dWithAmount((PoseStack)poseStack, (MultiBufferSource)buffers, (AEKey)this.getDisplayed(), (long)((MixinAbstractMonitorPartAccessor)((Object)this)).getAmount(), (boolean)((MixinAbstractMonitorPartAccessor)((Object)this)).getCanCraft(), (float)0.3f, (float)-0.15f, (int)this.getColor().contrastTextColor, (Level)this.getLevel());
            poseStack.translate(0.0f, -0.23f, 0.0f);
            String sign = this.lastReportedValue > 0.0 ? "+" : (this.lastReportedValue == 0.0 ? "" : "-");
            switch (this.workRoutine.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    MutableComponent mutableComponent = AAEText.OverdriveThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case 1: {
                    MutableComponent mutableComponent = AAEText.ThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case 2: {
                    MutableComponent mutableComponent = AAEText.SlowThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                    break;
                }
                case 3: {
                    MutableComponent mutableComponent = text = AAEText.SlowerThroughputMonitorValue.text(new Object[]{sign, this.lastHumanReadableValue});
                }
            }
            int color = this.lastReportedValue > 0.0 ? positiveColor : (this.lastReportedValue == 0.0 ? this.getColor().contrastTextColor : negativeColor);
            AAEBlockEntityRenderHelper.renderString(poseStack, buffers, (Component)text, color);
            poseStack.popPose();
        }
    }

    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }

    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        super.onMainNodeStateChanged(reason);
    }

    public TickingRequest getTickingRequest(IGridNode iGridNode) {
        return new TickingRequest(20, 100, !this.isActive() || this.getConfiguredItem() == null);
    }

    public TickRateModulation tickingRequest(IGridNode iGridNode, int i) {
        if (!this.getMainNode().isActive() || this.getConfiguredItem() == null) {
            this.resetState();
            return TickRateModulation.SLEEP;
        }
        long currentTick = TickHandler.instance().getCurrentTick();
        long currentAmount = this.getAmount();
        if (this.cache.size() == 0) {
            this.updateState(currentAmount, currentTick);
            this.lastHumanReadableValue = "-";
            return TickRateModulation.URGENT;
        }
        if (this.workRoutine == this.lastWorkRoutine) {
            double amountPerTick = this.cache.averagePerTick(this.workRoutine.timeLimit_s);
            this.lastReportedValue = amountPerTick * (double)this.workRoutine.ticks;
            this.lastHumanReadableValue = this.lastReportedValue > 10.0 || this.lastReportedValue == 0.0 ? this.getConfiguredItem().formatAmount(Math.round(Math.abs(this.lastReportedValue)), AmountFormat.SLOT) : String.format("%.2f", Math.abs(this.lastReportedValue));
        } else {
            this.lastHumanReadableValue = "";
        }
        this.updateState(currentAmount, currentTick);
        this.getHost().markForUpdate();
        return TickRateModulation.SLOWER;
    }

    private void resetState() {
        this.cache.clear();
        this.lastHumanReadableValue = "";
    }

    private void updateState(long amount, long tick) {
        this.cache.push(amount, tick);
        this.lastWorkRoutine = this.workRoutine;
    }

    private static enum WorkRoutine {
        TICK(1, 10),
        SECOND(20, 20),
        MINUTE(1200, AAEConfig.instance().getThroughputMonitorCacheSize() / 2),
        TEN_MINUTE(12000, AAEConfig.instance().getThroughputMonitorCacheSize() * 5);

        public final int ticks;
        public final int timeLimit_s;

        public static WorkRoutine cycle(WorkRoutine routine) {
            return switch (routine.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> SECOND;
                case 1 -> MINUTE;
                case 2 -> TEN_MINUTE;
                case 3 -> TICK;
            };
        }

        public static WorkRoutine fromInt(int value) {
            return switch (value) {
                case 0 -> TICK;
                case 2 -> MINUTE;
                case 3 -> TEN_MINUTE;
                default -> SECOND;
            };
        }

        private WorkRoutine(int ticks, int timeLimit_s) {
            this.ticks = ticks;
            this.timeLimit_s = timeLimit_s;
        }
    }
}

