/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import net.pedroksl.advanced_ae.common.inventory.QuantumArmorMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.IUpgradeableItem;
import net.pedroksl.advanced_ae.common.items.armors.PoweredItem;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.apoth.ApoEnchPlugin;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.util.GeckoLibUtil;

public class QuantumArmorBase
extends PoweredItem
implements GeoItem,
IMenuItem,
IUpgradeableItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final int DEFAULT_TINT_COLOR = AAEColor.PURPLE.argb();
    protected final List<UpgradeType> possibleUpgrades = new ArrayList<UpgradeType>();
    protected static final String MENU_TYPE = "aae$menutype";

    public QuantumArmorBase(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, DoubleSupplier powerCapacity) {
        super(material, type, properties.fireResistant().rarity(Rarity.EPIC).stacksTo(1), powerCapacity);
    }

    protected void registerUpgrades(UpgradeType ... upgrades) {
        this.possibleUpgrades.addAll(Arrays.asList(upgrades));
    }

    public int getTintColor(ItemStack stack) {
        return (Integer)stack.getOrDefault(AAEComponents.TINT_COLOR_TAG, (Object)DEFAULT_TINT_COLOR);
    }

    public void setTintColor(Player player, ItemStack stack, int color) {
        GeoRenderProvider provider;
        HumanoidModel renderer;
        stack.set(AAEComponents.TINT_COLOR_TAG, (Object)color);
        Object renderProvider = this.getRenderProvider();
        if (renderProvider instanceof GeoRenderProvider && (renderer = (provider = (GeoRenderProvider)renderProvider).getGeoArmorRenderer((LivingEntity)player, stack, stack.getEquipmentSlot(), null)) instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            quantumRenderer.setTintColor(color);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
        super.appendHoverText(stack, context, lines, advancedTooltips);
        Hotkeys.AAEHotkey hotkey = Hotkeys.getHotkeyMapping(AAEHotkeys.Keys.ARMOR_CONFIG.getId());
        if (hotkey != null) {
            lines.add((Component)AAEText.QuantumArmorHotkeyTooltip.text(new Object[]{hotkey.mapping().getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY));
        }
        this.appendExtraHoverText(stack, context, lines, advancedTooltips);
        if (this.getLinkedPosition(stack) == null) {
            lines.add((Component)Tooltips.of((GuiText)GuiText.Unlinked, (Style)Tooltips.RED, (Object[])new Object[0]));
        } else {
            lines.add((Component)Tooltips.of((GuiText)GuiText.Linked, (Style)Tooltips.GREEN, (Object[])new Object[0]));
        }
        lines.add((Component)Component.empty());
        lines.add((Component)AAEText.QuantumArmorTooltip.text().withStyle(Tooltips.NORMAL_TOOLTIP_TEXT));
        for (UpgradeType upgrade : this.possibleUpgrades) {
            MutableComponent upgradeComponent = Component.translatable((String)((QuantumUpgradeBaseItem)upgrade.item().asItem()).getDescriptionId());
            if (!this.hasUpgrade(stack, upgrade)) {
                upgradeComponent.append((Component)AAEText.UpgradeNotInstalled.text());
                upgradeComponent.withStyle(Tooltips.MUTED_COLOR);
            } else {
                upgradeComponent.withStyle(Tooltips.GREEN);
            }
            lines.add((Component)upgradeComponent);
        }
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    protected void appendExtraHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advancedTooltips) {
    }

    @Override
    public List<UpgradeType> getPossibleUpgrades() {
        return this.possibleUpgrades;
    }

    protected boolean checkPreconditions(ItemStack item) {
        return !item.isEmpty() && item.getItem() == this;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (Addons.APOTHIC_ENCHANTING.isLoaded() && ((Enchantment)enchantment.value()).effects().has(ApoEnchPlugin.getEnchantment(ApoEnchPlugin.Enchantment.STABLE_FOOTING))) {
            return false;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    public boolean openFromEquipmentSlot(Player player, ItemMenuHostLocator locator) {
        return this.openFromEquipmentSlot(player, locator, false);
    }

    public boolean openFromEquipmentSlot(Player player, ItemMenuHostLocator locator, boolean returningFromSubmenu) {
        ItemStack is = locator.locateItem(player);
        if (!player.level().isClientSide() && this.checkPreconditions(is)) {
            return MenuOpener.open(AAEMenus.QUANTUM_ARMOR_CONFIG.get(), (Player)player, (MenuHostLocator)locator, (boolean)returningFromSubmenu);
        }
        return false;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<Item> onBroken) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.consumeEnergy(player, stack, amount);
        }
        return 0;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private QuantumArmorRenderer renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new QuantumArmorRenderer();
                }
                this.renderer.setTintColor(QuantumArmorBase.this.getTintColor(itemStack));
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, 20, state -> {
            state.getController().setAnimation(RawAnimation.begin().thenLoop("animation.quantum_armor.idle"));
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (!(entity instanceof Player)) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : ((Player)entity).getArmorSlots()) {
                if (stack.isEmpty()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.getItem());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new QuantumArmorBase[]{(QuantumArmorBase)AAEItems.QUANTUM_BOOTS.get(), (QuantumArmorBase)AAEItems.QUANTUM_LEGGINGS.get(), (QuantumArmorBase)AAEItems.QUANTUM_CHESTPLATE.get(), (QuantumArmorBase)AAEItems.QUANTUM_HELMET.get()}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new QuantumArmorMenuHost<QuantumArmorBase>(this, player, locator, (p, subMenu) -> this.openFromEquipmentSlot((Player)p, locator, true));
    }

    public static List<QuantumArmorBase> upgradeAvailableFor(UpgradeType type) {
        ArrayList<QuantumArmorBase> list = new ArrayList<QuantumArmorBase>();
        for (ItemDefinition<?> equip : AAEItems.getQuantumArmor()) {
            QuantumArmorBase armor = (QuantumArmorBase)equip.stack().getItem();
            if (!armor.possibleUpgrades.contains((Object)type)) continue;
            list.add(armor);
        }
        return list;
    }

    protected static enum MenuId {
        STANDARD(0),
        WORKBENCH(1),
        CRAFTING(2);

        public final int id;

        private MenuId(int id) {
            this.id = id;
        }
    }
}

