/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.blocks;

import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.crafting.PushDirection;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.pedroksl.advanced_ae.common.blocks.AdvPatternProviderBlock;
import net.pedroksl.advanced_ae.common.entities.SmallAdvPatternProviderEntity;

public class SmallAdvPatternProviderBlock
extends AEBaseEntityBlock<SmallAdvPatternProviderEntity> {
    public SmallAdvPatternProviderBlock() {
        super(SmallAdvPatternProviderBlock.metalProps());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)PushDirection.ALL)).setValue((Property)AdvPatternProviderBlock.CONNECTION_STATE, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PatternProviderBlock.PUSH_DIRECTION});
        builder.add(new Property[]{AdvPatternProviderBlock.CONNECTION_STATE});
    }

    @ParametersAreNonnullByDefault
    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        SmallAdvPatternProviderEntity be = (SmallAdvPatternProviderEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (InteractionUtil.isInAlternateUseMode((Player)player)) {
            return InteractionResult.PASS;
        }
        SmallAdvPatternProviderEntity be = (SmallAdvPatternProviderEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.isClientSide()) {
                be.openMenu(player, MenuLocators.forBlockEntity((BlockEntity)be));
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (InteractionUtil.canWrenchRotate((ItemStack)heldItem)) {
            this.setSide(level, pos, hit.getDirection());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(heldItem, state, level, pos, player, hand, hit);
    }

    public void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.getBlockState(pos);
        Direction pushSide = ((PushDirection)currentState.getValue((Property)PatternProviderBlock.PUSH_DIRECTION)).getDirection();
        PushDirection newPushDirection = pushSide == facing.getOpposite() ? PushDirection.fromDirection((Direction)facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection((Direction)facing.getOpposite()) : PushDirection.fromDirection((Direction)Platform.rotateAround((Direction)pushSide, (Direction)facing))));
        level.setBlockAndUpdate(pos, (BlockState)currentState.setValue((Property)PatternProviderBlock.PUSH_DIRECTION, (Comparable)newPushDirection));
    }
}

