/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.widgets;

import appeng.api.stacks.GenericStack;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeSettings;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import org.jetbrains.annotations.Nullable;

public record UpgradeState(UpgradeType type, UpgradeSettings settings, boolean enabled, int currentValue, @Nullable List<GenericStack> filter) {
    public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeState> STREAM_CODEC = StreamCodec.ofMember(UpgradeState::write, UpgradeState::decode);

    public UpgradeState(UpgradeType type, UpgradeSettings settings, boolean enabled, int currentValue) {
        this(type, settings, enabled, currentValue, List.of());
    }

    public static UpgradeState decode(RegistryFriendlyByteBuf stream) {
        UpgradeType type = (UpgradeType)stream.readEnum(UpgradeType.class);
        UpgradeSettings settings = (UpgradeSettings)UpgradeSettings.STREAM_CODEC.decode((Object)stream);
        boolean enabled = stream.readBoolean();
        int currentValue = stream.readInt();
        if (stream.readBoolean()) {
            List filter = (List)GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)stream);
            return new UpgradeState(type, settings, enabled, currentValue, filter);
        }
        return new UpgradeState(type, settings, enabled, currentValue);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeEnum((Enum)this.type);
        UpgradeSettings.STREAM_CODEC.encode((Object)data, (Object)this.settings);
        data.writeBoolean(this.enabled);
        data.writeInt(this.currentValue);
        if (this.filter != null) {
            data.writeBoolean(true);
            GenericStack.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)data, this.filter);
        }
    }
}

