/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.IResizableWidget;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.renderer.Rect2i;

public class AAECompositeWidgetContainer
implements ICompositeWidget {
    protected final WidgetStyle style;
    protected Point position;
    protected int width;
    protected int height;
    protected boolean wantsAllMouseUp = false;
    protected boolean wantsAllMouseDown = false;
    protected boolean wantsAllMouseWheel = false;
    private final Map<Point, ICompositeWidget> widgets = new LinkedHashMap<Point, ICompositeWidget>();
    private final Map<Point, AbstractWidget> abstractWidgets = new LinkedHashMap<Point, AbstractWidget>();

    public AAECompositeWidgetContainer(BiConsumer<String, ICompositeWidget> addWidget, ScreenStyle style, String id) {
        this.style = style.getWidget(id);
        this.setSize(this.style.getWidth(), this.style.getHeight());
        addWidget.accept(id, this);
    }

    public void add(Point pos, ICompositeWidget widget) {
        this.widgets.put(pos, widget);
        this.wantsAllMouseUp |= widget.wantsAllMouseUpEvents();
        this.wantsAllMouseDown |= widget.wantsAllMouseDownEvents();
        this.wantsAllMouseWheel |= widget.wantsAllMouseWheelEvents();
    }

    public void add(Point pos, AbstractWidget widget) {
        this.abstractWidgets.put(pos, widget);
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.position.getX(), this.position.getY(), this.width, this.height);
    }

    public void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        AbstractWidget widget;
        Point pos;
        Rect2i relativeBounds = new Rect2i(0, 0, bounds.getWidth(), bounds.getHeight());
        for (Map.Entry<Point, AbstractWidget> entry : this.abstractWidgets.entrySet()) {
            pos = entry.getKey();
            widget = entry.getValue();
            if (widget.isFocused()) {
                widget.setFocused(false);
            }
            relativeBounds.setPosition(bounds.getX() + pos.getX(), bounds.getY() + pos.getY());
            Point absolutePos = this.style.resolve(relativeBounds);
            if (widget instanceof IResizableWidget) {
                IResizableWidget resizableWidget = (IResizableWidget)widget;
                resizableWidget.move(absolutePos);
            } else {
                widget.setX(absolutePos.getX());
                widget.setY(absolutePos.getY());
            }
            addWidget.accept(widget);
        }
        relativeBounds = new Rect2i(0, 0, bounds.getWidth(), bounds.getHeight());
        for (Map.Entry<Point, AbstractWidget> entry : this.widgets.entrySet()) {
            pos = entry.getKey();
            widget = (ICompositeWidget)entry.getValue();
            relativeBounds.setPosition(pos.getX(), pos.getY());
            widget.setPosition(this.style.resolve(relativeBounds));
            widget.populateScreen(addWidget, bounds, screen);
        }
    }

    public void tick() {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible()) continue;
            widget.tick();
        }
    }

    public void updateBeforeRender() {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible()) continue;
            widget.updateBeforeRender();
        }
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible()) continue;
            widget.drawBackgroundLayer(guiGraphics, bounds, mouse);
        }
    }

    public void drawForegroundLayer(GuiGraphics poseStack, Rect2i bounds, Point mouse) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible()) continue;
            widget.drawForegroundLayer(poseStack, bounds, mouse);
        }
    }

    public boolean onMouseDown(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible() || !widget.wantsAllMouseDownEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseDown(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseUp(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible() || !widget.wantsAllMouseUpEvents() && !mousePos.isIn(widget.getBounds()) || !widget.onMouseUp(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseDrag(Point mousePos, int btn) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible() || !widget.onMouseDrag(mousePos, btn)) continue;
            return true;
        }
        return false;
    }

    public boolean onMouseWheel(Point mousePos, double wheelDelta) {
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible() || !mousePos.isIn(widget.getBounds()) || !widget.onMouseWheel(mousePos, wheelDelta)) continue;
            return true;
        }
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible() || !widget.wantsAllMouseWheelEvents() || !widget.onMouseWheel(mousePos, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    public boolean wantsAllMouseUpEvents() {
        return this.wantsAllMouseUp;
    }

    public boolean wantsAllMouseDownEvents() {
        return this.wantsAllMouseDown;
    }

    public boolean wantsAllMouseWheelEvents() {
        return this.wantsAllMouseWheel;
    }

    public void addExclusionZones(List<Rect2i> exclusionZones, Rect2i bounds) {
        super.addExclusionZones(exclusionZones, bounds);
        for (ICompositeWidget widget : this.widgets.values()) {
            if (!widget.isVisible()) continue;
            widget.addExclusionZones(exclusionZones, bounds);
        }
    }
}

