/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.widgets.IconButton;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import org.jetbrains.annotations.Nullable;

public class AAEActionButton
extends IconButton {
    private static final Pattern PATTERN_NEW_LINE = Pattern.compile("\\n", 16);
    private final Icon icon;

    public AAEActionButton(AAEActionItems action, Runnable onPress) {
        this(action, (AAEActionItems a) -> onPress.run());
    }

    public AAEActionButton(AAEActionItems action, Consumer<AAEActionItems> onPress) {
        super(btn -> onPress.accept(action));
        AAEText displayName;
        this.setMessage(this.buildMessage(displayName, switch (action) {
            case AAEActionItems.F_FLUSH -> {
                this.icon = Icon.S_CLEAR;
                displayName = AAEText.ClearButton;
                yield AAEText.ClearFluidButtonHint;
            }
            case AAEActionItems.CLEAR -> {
                this.icon = Icon.S_CLEAR;
                displayName = AAEText.ClearButton;
                yield AAEText.ClearSidesButtonHint;
            }
            default -> throw new IllegalArgumentException("Unknown ActionItem: " + String.valueOf((Object)action));
        }));
    }

    protected Icon getIcon() {
        return this.icon;
    }

    private Component buildMessage(AAEText displayName, @Nullable AAEText displayValue) {
        String name = displayName.text().getString();
        if (displayValue == null) {
            return Component.literal((String)name);
        }
        String value = displayValue.text().getString();
        StringBuilder sb = new StringBuilder(value = PATTERN_NEW_LINE.matcher(value).replaceAll("\n"));
        int i = sb.lastIndexOf("\n");
        if (i <= 0) {
            i = 0;
        }
        while (i + 30 < sb.length() && (i = sb.lastIndexOf(" ", i + 30)) != -1) {
            sb.replace(i, i + 1, "\n");
        }
        return Component.literal((String)(name + "\n" + String.valueOf(sb)));
    }
}

