/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.IconButton;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.core.definitions.AEItems;
import appeng.core.localization.Tooltips;
import appeng.menu.SlotSemantics;
import appeng.menu.implementations.UpgradeableMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.ItemLike;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEServerSettingToggleButton;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEToolbarActionButton;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.gui.QuantumCrafterMenu;

public class QuantumCrafterScreen
extends UpgradeableScreen<QuantumCrafterMenu> {
    private final SettingToggleButton<RedstoneMode> redstoneMode;
    private final AAEServerSettingToggleButton<YesNo> meExportBtn;
    private final AAEToolbarActionButton outputConfigure;
    private final List<Button> configButtons = new ArrayList<Button>();
    private final List<AECheckbox> enableButtons = new ArrayList<AECheckbox>();
    private final InvalidPatternAlert invalidPatternAlert;
    private final List<Boolean> invalidPatternSlots;

    public QuantumCrafterScreen(QuantumCrafterMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.redstoneMode = new ServerSettingToggleButton(Settings.REDSTONE_CONTROLLED, (Enum)RedstoneMode.IGNORE);
        this.addToLeftToolbar((Button)this.redstoneMode);
        this.meExportBtn = new AAEServerSettingToggleButton<YesNo>(AAESettings.ME_EXPORT, YesNo.NO);
        this.addToLeftToolbar(this.meExportBtn);
        this.outputConfigure = new AAEToolbarActionButton(AAEActionItems.DIRECTIONAL_OUTPUT, btn -> menu.configureOutput());
        this.outputConfigure.setVisibility(((QuantumCrafterMenu)this.getMenu()).getMeExport() == YesNo.NO);
        this.addToLeftToolbar(this.outputConfigure);
        List patternSlots = menu.getSlots(SlotSemantics.MACHINE_INPUT);
        this.invalidPatternSlots = new ArrayList<Boolean>(Collections.nCopies(patternSlots.size(), Boolean.FALSE));
        for (int i = 0; i < patternSlots.size(); ++i) {
            ConfigButton cfgButton = new ConfigButton(btn -> {
                int idx = this.configButtons.indexOf(btn);
                menu.configPattern(idx);
            });
            cfgButton.setDisableBackground(true);
            cfgButton.setMessage((Component)AAEText.ConfigurePatternButton.text());
            this.widgets.add("cfgButton" + (1 + i), (AbstractWidget)cfgButton);
            this.configButtons.add((Button)cfgButton);
            AECheckbox enableButton = this.widgets.addCheckbox("enableButton" + (1 + i), (Component)Component.empty(), (Runnable)new onEnableToggle(i));
            enableButton.setRadio(true);
            enableButton.setTooltip(Tooltip.create((Component)AAEText.EnablePatternButton.text()));
            this.enableButtons.add(enableButton);
        }
        this.invalidPatternAlert = new InvalidPatternAlert(style.getImage("invalidPatternAlert"));
        this.invalidPatternAlert.setTooltip(Tooltip.create((Component)Tooltips.of((Component[])new Component[]{AAEText.InvalidPattern.text().withStyle(Tooltips.RED), Component.literal((String)"\n").append((Component)AAEText.InvalidPatternDetails.text()).withStyle(Tooltips.NORMAL_TOOLTIP_TEXT)})));
        this.widgets.add("invalidPatternAlert", (AbstractWidget)this.invalidPatternAlert);
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.redstoneMode.set((Enum)((QuantumCrafterMenu)this.menu).getRedStoneMode());
        this.redstoneMode.setVisibility(((QuantumCrafterMenu)this.menu).hasUpgrade((ItemLike)AEItems.REDSTONE_CARD));
        this.meExportBtn.set(((QuantumCrafterMenu)this.getMenu()).getMeExport());
        this.outputConfigure.setVisibility(((QuantumCrafterMenu)this.getMenu()).getMeExport() == YesNo.NO);
        this.invalidPatternAlert.visible = this.invalidPatternSlots.contains(true);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        for (int x = 0; x < this.invalidPatternSlots.size(); ++x) {
            if (!this.invalidPatternSlots.get(x).booleanValue()) continue;
            Slot slot = (Slot)((QuantumCrafterMenu)this.menu).getSlots(SlotSemantics.MACHINE_INPUT).get(x);
            AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.x + offsetX), (int)(slot.y + offsetY), (int)0, (int)2029652490);
        }
    }

    public void updateInvalidButtons(List<Boolean> invalidPatterns) {
        for (int x = 0; x < this.invalidPatternSlots.size(); ++x) {
            if (invalidPatterns.size() <= x) continue;
            this.invalidPatternSlots.set(x, invalidPatterns.get(x));
        }
    }

    public void updateEnabledButtons(List<Boolean> enabledButtons) {
        for (int x = 0; x < this.enableButtons.size(); ++x) {
            if (enabledButtons.size() <= x) continue;
            this.enableButtons.get(x).setSelected(enabledButtons.get(x).booleanValue());
        }
    }

    static class ConfigButton
    extends IconButton {
        public ConfigButton(Button.OnPress onPress) {
            super(onPress);
        }

        protected Icon getIcon() {
            return this.isHoveredOrFocused() ? Icon.COG : Icon.COG_DISABLED;
        }
    }

    private class onEnableToggle
    implements Runnable {
        private final int index;

        onEnableToggle(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            ((QuantumCrafterMenu)QuantumCrafterScreen.this.menu).toggleEnablePattern(this.index);
        }
    }

    private static class InvalidPatternAlert
    extends AbstractWidget {
        private final Blitter invalidPatternAlert;

        public InvalidPatternAlert(Blitter powerAlert) {
            super(0, 0, 18, 18, (Component)Component.empty());
            this.invalidPatternAlert = powerAlert;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int i1, float v) {
            this.invalidPatternAlert.dest(this.getX(), this.getY()).blit(guiGraphics);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

