/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.orientation.RelativeSide;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionButton;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEActionItems;
import net.pedroksl.advanced_ae.client.gui.widgets.OutputDirectionButton;
import net.pedroksl.advanced_ae.gui.OutputDirectionMenu;

public class OutputDirectionScreen
extends AEBaseScreen<OutputDirectionMenu> {
    private static final int BUTTON_WIDTH = 18;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_TOP_OFFSET = 6;
    private static final int BUTTON_LEFT_OFFSET = 7;
    private static final int BUTTON_OFFSET = 2;
    private final List<OutputDirectionButton> buttons = new ArrayList<OutputDirectionButton>();

    public OutputDirectionScreen(OutputDirectionMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        for (RelativeSide side : RelativeSide.values()) {
            int[] pos = this.getButtonPosition(side);
            OutputDirectionButton button = new OutputDirectionButton(this.leftPos + pos[0], this.topPos + pos[1], 18, 20, this::buttonPressed);
            button.setSide(side);
            this.buttons.add(button);
            this.addRenderableWidget((GuiEventListener)button);
        }
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        AAEActionButton clearBtn = new AAEActionButton(AAEActionItems.CLEAR, btn -> menu.clearSides());
        clearBtn.setHalfSize(true);
        clearBtn.setDisableBackground(true);
        this.widgets.add("clearAll", (AbstractWidget)clearBtn);
    }

    protected void init() {
        super.init();
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            int[] pos = this.getButtonPosition(button.getSide());
            button.setPosition(this.leftPos + pos[0], this.topPos + pos[1]);
        }
    }

    public void update(Set<RelativeSide> sides) {
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            button.setEnabled(sides.contains(side));
        }
    }

    protected void updateBeforeRender() {
        for (OutputDirectionButton button : this.buttons) {
            RelativeSide side = button.getSide();
            if (side == null) continue;
            int[] pos = this.getButtonPosition(side);
            button.setPosition(this.leftPos + pos[0], this.topPos + pos[1]);
            ItemStack item = ((OutputDirectionMenu)this.getMenu()).getAdjacentBlock(side);
            button.setItemStack(item);
        }
        super.updateBeforeRender();
    }

    private int[] getButtonPosition(RelativeSide side) {
        int[] nArray;
        switch (side) {
            default: {
                throw new MatchException(null, null);
            }
            case FRONT: {
                int[] nArray2 = new int[2];
                nArray2[0] = 27;
                nArray = nArray2;
                nArray2[1] = 28;
                break;
            }
            case BACK: {
                int[] nArray3 = new int[2];
                nArray3[0] = 47;
                nArray = nArray3;
                nArray3[1] = 50;
                break;
            }
            case TOP: {
                int[] nArray4 = new int[2];
                nArray4[0] = 27;
                nArray = nArray4;
                nArray4[1] = 6;
                break;
            }
            case RIGHT: {
                int[] nArray5 = new int[2];
                nArray5[0] = 7;
                nArray = nArray5;
                nArray5[1] = 28;
                break;
            }
            case BOTTOM: {
                int[] nArray6 = new int[2];
                nArray6[0] = 27;
                nArray = nArray6;
                nArray6[1] = 50;
                break;
            }
            case LEFT: {
                int[] nArray7 = new int[2];
                nArray7[0] = 47;
                nArray = nArray7;
                nArray7[1] = 28;
            }
        }
        return nArray;
    }

    private void buttonPressed(Button b) {
        OutputDirectionButton button;
        RelativeSide side;
        if (b instanceof OutputDirectionButton && (side = (button = (OutputDirectionButton)b).getSide()) != null) {
            ((OutputDirectionMenu)this.getMenu()).updateSideStatus(button.getSide());
        }
    }
}

