/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.stairs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_STAIRS})
public final class StairsSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            StairsShape shape = (StairsShape)state.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
            Half half = (Half)state.getValue((Property)BlockStateProperties.HALF);
            return switch (blockType) {
                case BlockType.FRAMED_STAIRS -> StairsSkipPredicate.testAgainstStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_HALF_SLOPE -> StairsSkipPredicate.testAgainstHalfSlope(dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> StairsSkipPredicate.testAgainstVerticalHalfSlope(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> StairsSkipPredicate.testAgainstSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> StairsSkipPredicate.testAgainstElevatedSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> StairsSkipPredicate.testAgainstCornerSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> StairsSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> StairsSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE -> StairsSkipPredicate.testAgainstElevatedInnerCornerSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE -> StairsSkipPredicate.testAgainstInnerThreewayCornerSlopeEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB -> StairsSkipPredicate.testAgainstSlab(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> StairsSkipPredicate.testAgainstSlabEdge(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> StairsSkipPredicate.testAgainstSlabCorner(dir, shape, half, adjState, side);
                case BlockType.FRAMED_PANEL -> StairsSkipPredicate.testAgainstPanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_CORNER_PILLAR -> StairsSkipPredicate.testAgainstCornerPillar(dir, shape, half, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> StairsSkipPredicate.testAgainstHalfStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> StairsSkipPredicate.testAgainstSlopedStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> StairsSkipPredicate.testAgainstVerticalStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> StairsSkipPredicate.testAgainstVerticalHalfStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_VERTICAL_SLOPED_STAIRS -> StairsSkipPredicate.testAgainstVerticalSlopedStairs(dir, shape, half, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> StairsSkipPredicate.testAgainstThreewayCornerPillar(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstSlopeSlab(dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> StairsSkipPredicate.testAgainstElevatedSlopeSlab(dir, shape, half, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> StairsSkipPredicate.testAgainstCompoundSlopeSlab(dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> StairsSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_PANEL -> StairsSkipPredicate.testAgainstCompoundSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatInnerSlopePanelCorner(dir, shape, half, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> StairsSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstSmallCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstLargeCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> StairsSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, shape, half, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstSmallInnerCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstLargeInnerCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> StairsSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL -> StairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanel(dir, shape, half, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> StairsSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, shape, half, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> StairsSkipPredicate.testAgainstElevatedPyramidSlab(dir, shape, half, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> StairsSkipPredicate.testAgainstMasonryCornerSegment(dir, shape, half, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> StairsSkipPredicate.testAgainstCheckeredPanelSegment(dir, shape, half, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> StairsSkipPredicate.testAgainstLayeredCube(dir, shape, half, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(StairsDirs.Stairs.getStairDir(adjDir, adjShape, adjHalf, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite())) || StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(StairsDirs.Stairs.getCornerDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_SLOPE})
    private static boolean testAgainstHalfSlope(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeDirs.HalfSlope.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getStairDir(adjDir, adjType, adjAlt, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite())) || StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedInnerCornerSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.ElevatedInnerCornerSlopeEdge.getStairDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_THREEWAY_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerThreewayCornerSlopeEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopeEdgeDirs.InnerThreewayCornerSlopeEdge.getStairDir(adjDir, adjTop, adjRight, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlabDirs.SlabCorner.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PANEL})
    private static boolean testAgainstPanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlabDirs.Panel.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_PILLAR})
    private static boolean testAgainstCornerPillar(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(PillarDirs.CornerPillar.getCornerDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(StairsDirs.HalfStairs.getStairDir(adjDir, adjTop, adjRight, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.HalfStairs.getHalfDir(adjDir, adjTop, adjRight, side.getOpposite())) || StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(StairsDirs.HalfStairs.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalStairs.getStairDir(adjDir, adjType, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalStairs.getHalfDir(adjDir, adjType, side.getOpposite())) || StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalStairs.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalHalfStairs.getStairDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_SLOPED_STAIRS})
    private static boolean testAgainstVerticalSlopedStairs(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(StairsDirs.VerticalSlopedStairs.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getStairDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_PANEL})
    private static boolean testAgainstSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelDirs.SlopePanel.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_PANEL})
    private static boolean testAgainstCompoundSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelDirs.CompoundSlopePanel.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatInnerSlopePanelCorner(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.getValue((Property)PropertyHolder.FRONT);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelDirs.FlatInnerSlopePanelCorner.getHalfDir(adjDir, adjRot, adjFront, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getHalfDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstSmallInnerCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstLargeInnerCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanel.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL})
    private static boolean testAgainstExtendedInnerCornerSlopePanel(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanel.getStairDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanelWall.getStairDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return StairsDirs.Stairs.getStairDir(dir, shape, half, side).isEqualTo(SlabDirs.MasonryCornerSegment.getStairDir(adjDir, adjTop, side.getOpposite())) || StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(SlabDirs.MasonryCornerSegment.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return StairsDirs.Stairs.getCornerDir(dir, shape, half, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, StairsShape shape, Half half, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return StairsDirs.Stairs.getHalfDir(dir, shape, half, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

