/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopeslab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.misc.MiscDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slope.SlopeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
public final class FlatInnerSlopeSlabCornerSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            boolean topHalf = (Boolean)state.getValue((Property)PropertyHolder.TOP_HALF);
            return switch (blockType) {
                case BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatInnerSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_SLOPE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfSlope(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstInnerCornerSlopeEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlabEdge(dir, topHalf, adjState, side);
                case BlockType.FRAMED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPED_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopedStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstVerticalHalfStairs(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSlopeSlab(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedSlopeSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_COMPOUND_SLOPE_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstCompoundSlopeSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatSlopeSlabCorner(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLargeInnerCornerSlopePanelWall(dir, top, topHalf, adjState, side);
                case BlockType.FRAMED_ELEVATED_PYRAMID_SLAB -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstElevatedPyramidSlab(dir, topHalf, adjState, side);
                case BlockType.FRAMED_LAYERED_CUBE -> FlatInnerSlopeSlabCornerSkipPredicate.testAgainstLayeredCube(dir, topHalf, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatInnerSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(adjDir, adjTop, adjTopHalf, side.getOpposite())) || SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_SLOPE})
    private static boolean testAgainstVerticalHalfSlope(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeDirs.VerticalHalfSlope.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_EDGE})
    private static boolean testAgainstSlopeEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeEdgeDirs.SlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_EDGE})
    private static boolean testAgainstElevatedSlopeEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.getValue(PropertyHolder.SLOPE_TYPE));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeEdgeDirs.ElevatedSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_INNER_CORNER_SLOPE_EDGE})
    private static boolean testAgainstInnerCornerSlopeEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeEdgeDirs.InnerCornerSlopeEdge.getHalfDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getHalfDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB})
    private static boolean testAgainstSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlabDirs.Slab.getHalfDir(adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlabDirs.SlabEdge.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_STAIRS})
    private static boolean testAgainstStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        StairsShape adjShape = (StairsShape)adjState.getValue((Property)BlockStateProperties.STAIRS_SHAPE);
        Half adjHalf = (Half)adjState.getValue((Property)BlockStateProperties.HALF);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(StairsDirs.Stairs.getHalfDir(adjDir, adjShape, adjHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_STAIRS})
    private static boolean testAgainstSlopedStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(StairsDirs.SlopedStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(StairsDirs.VerticalHalfStairs.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPE_SLAB})
    private static boolean testAgainstSlopeSlab(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getTriDir(adjDir, adjTop, adjTopHalf, side.getOpposite())) || SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabDirs.SlopeSlab.getHalfDir(adjDir, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_COMPOUND_SLOPE_SLAB})
    private static boolean testAgainstCompoundSlopeSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabDirs.CompoundSlopeSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatSlopeSlabCorner(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjTopHalf = (Boolean)adjState.getValue((Property)PropertyHolder.TOP_HALF);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopeSlabDirs.FlatSlopeSlabCorner.getTriDir(adjDir, adjTop, adjTopHalf, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getHalfDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopePanelCornerDirs.LargeCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstLargeInnerCornerSlopePanelWall(Direction dir, boolean top, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getTriDir(dir, top, topHalf, side).isEqualTo(SlopePanelCornerDirs.LargeInnerCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_PYRAMID_SLAB})
    private static boolean testAgainstElevatedPyramidSlab(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(SlopeDirs.ElevatedPyramidSlab.getHalfDir(adjDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_LAYERED_CUBE})
    private static boolean testAgainstLayeredCube(Direction dir, boolean topHalf, BlockState adjState, Direction side) {
        Direction adjFacing = (Direction)adjState.getValue((Property)BlockStateProperties.FACING);
        int adjLayers = (Integer)adjState.getValue((Property)BlockStateProperties.LAYERS);
        return SlopeSlabDirs.FlatInnerSlopeSlabCorner.getHalfDir(dir, topHalf, side).isEqualTo(MiscDirs.LayeredCube.getHalfDir(adjFacing, adjLayers, side.getOpposite()));
    }
}

