/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CompoundDirection;
import xfacthd.framedblocks.common.data.property.DirectionAxis;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.prism.PrismDirs;

@CullTest(value={BlockType.FRAMED_SLOPED_PRISM})
public final class SlopedPrismSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        if (PrismDirs.SlopedPrism.testEarlyExit(cmpDir, side)) {
            return false;
        }
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            return switch (blockType) {
                case BlockType.FRAMED_SLOPED_PRISM -> SlopedPrismSkipPredicate.testAgainstSlopedPrism(cmpDir, adjState, side);
                case BlockType.FRAMED_PRISM -> SlopedPrismSkipPredicate.testAgainstPrism(cmpDir, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLOPED_PRISM})
    private static boolean testAgainstSlopedPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        CompoundDirection adjCmpDir = (CompoundDirection)((Object)adjState.getValue(PropertyHolder.FACING_DIR));
        return PrismDirs.SlopedPrism.getTriDir(cmpDir, side).isEqualTo(PrismDirs.SlopedPrism.getTriDir(adjCmpDir, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_PRISM})
    private static boolean testAgainstPrism(CompoundDirection cmpDir, BlockState adjState, Direction side) {
        DirectionAxis adjDirAxis = (DirectionAxis)((Object)adjState.getValue(PropertyHolder.FACING_AXIS));
        return PrismDirs.SlopedPrism.getTriDir(cmpDir, side).isEqualTo(PrismDirs.Prism.getTriDir(adjDirAxis, side.getOpposite()));
    }
}

