/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class CheckeredSlabSegmentShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape shapeBotFirst = ShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0));
        VoxelShape shapeTopFirst = ShapeUtils.or(Block.box((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0));
        VoxelShape shapeBotSecond = ShapeUtils.rotateShapeAroundY(Direction.NORTH, Direction.EAST, shapeBotFirst);
        VoxelShape shapeTopSecond = ShapeUtils.rotateShapeAroundY(Direction.NORTH, Direction.EAST, shapeTopFirst);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
            boolean second = (Boolean)state.getValue((Property)PropertyHolder.SECOND);
            builder.put((Object)state, (Object)(second ? (top ? shapeTopSecond : shapeBotSecond) : (top ? shapeTopFirst : shapeBotFirst)));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private CheckeredSlabSegmentShapes() {
    }
}

