/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;

public final class MiniCubeShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape bottomShape = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        VoxelShape topShape = Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        UnmodifiableIterator unmodifiableIterator = states.iterator();
        while (unmodifiableIterator.hasNext()) {
            BlockState state;
            boolean top = (Boolean)(state = (BlockState)unmodifiableIterator.next()).getValue((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)(top ? topShape : bottomShape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private MiniCubeShapes() {
    }
}

