/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.cube;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerTubeOrientation;

public final class CornerTubeShapes {
    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        VoxelShape[] thinShapes = CornerTubeShapes.makeShapes(2);
        VoxelShape[] thickShapes = CornerTubeShapes.makeShapes(3);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            CornerTubeOrientation orientation = (CornerTubeOrientation)((Object)state.getValue(PropertyHolder.CORNER_TYPE_ORIENTATION));
            boolean thick = (Boolean)state.getValue((Property)PropertyHolder.THICK);
            VoxelShape shape = (thick ? thickShapes : thinShapes)[orientation.ordinal()];
            builder.put((Object)state, (Object)shape);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static VoxelShape[] makeShapes(int thickness) {
        int max = 16 - thickness;
        VoxelShape shapeUpNorth = ShapeUtils.andUnoptimized(Shapes.joinUnoptimized((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)thickness, (double)thickness, (double)thickness, (double)max, (double)16.0, (double)max), (BooleanOp)BooleanOp.ONLY_FIRST), Shapes.joinUnoptimized((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)thickness, (double)thickness, (double)0.0, (double)max, (double)max, (double)max), (BooleanOp)BooleanOp.ONLY_FIRST));
        VoxelShape shapeDownNorth = ShapeUtils.rotateShapeAroundZ(Direction.UP, Direction.DOWN, shapeUpNorth);
        VoxelShape shapeNorthEast = ShapeUtils.rotateShapeAroundZ(Direction.UP, Direction.EAST, shapeUpNorth);
        VoxelShape[] shapes = new VoxelShape[CornerTubeOrientation.COUNT];
        ShapeUtils.makeHorizontalRotations(shapeUpNorth, Direction.SOUTH, shapes, 0);
        ShapeUtils.makeHorizontalRotations(shapeDownNorth, Direction.SOUTH, shapes, 4);
        ShapeUtils.makeHorizontalRotations(shapeNorthEast, Direction.SOUTH, shapes, 8);
        return shapes;
    }

    private CornerTubeShapes() {
    }
}

