/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.slopeedge;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.NonDetailedConnectionPredicate;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public final class ElevatedDoubleCornerSlopeEdgeConnectionPredicate
extends NonDetailedConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        Direction yBack;
        Direction xBack;
        Direction baseFace;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        switch (type) {
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            default: {
                Direction direction = baseFace = dir;
            }
        }
        if (side == baseFace || edge == baseFace) {
            return true;
        }
        if (type.isHorizontal()) {
            xBack = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
            yBack = type.isTop() ? Direction.UP : Direction.DOWN;
        } else {
            xBack = dir;
            yBack = dir.getCounterClockWise();
        }
        if (side == xBack && edge == yBack || side == yBack && edge == xBack) {
            return true;
        }
        if ((side == xBack.getOpposite() || side == yBack.getOpposite()) && edge == baseFace.getOpposite()) {
            return true;
        }
        return side == baseFace.getOpposite() && (edge == xBack.getOpposite() || edge == yBack.getOpposite());
    }
}

