/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import xfacthd.framedblocks.common.FBContent;

public final class ShapeRotationRecipe
extends ShapelessRecipe {
    public static final MapCodec<ShapeRotationRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC.fieldOf("tool").forGetter(recipe -> recipe.tool), (App)Ingredient.CODEC.fieldOf("block").forGetter(recipe -> recipe.block)).apply((Applicative)inst, ShapeRotationRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShapeRotationRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ShapelessRecipe::getGroup, (StreamCodec)ItemStack.STREAM_CODEC, recipe -> recipe.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.tool, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.block, ShapeRotationRecipe::new);
    private final Ingredient tool;
    private final Ingredient block;

    public ShapeRotationRecipe(String group, ItemStack result, Ingredient tool, Ingredient block) {
        super(group, CraftingBookCategory.BUILDING, result, NonNullList.of(null, (Object[])new Ingredient[]{tool, block}));
        this.tool = tool;
        this.block = block;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainders = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!this.tool.test(stack)) continue;
            remainders.set(i, (Object)stack.copy());
        }
        return remainders;
    }

    public RecipeSerializer<ShapelessRecipe> getSerializer() {
        return (RecipeSerializer)FBContent.RECIPE_SERIALIZER_SHAPE_ROTATION.value();
    }
}

