/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.create;

import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.api.schematic.nbt.SafeNbtWriterRegistry;
import com.simibubi.create.api.schematic.requirement.SchematicRequirementRegistries;
import com.simibubi.create.api.schematic.state.SchematicStateFilterRegistry;
import com.simibubi.create.content.contraptions.behaviour.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.FenceGateMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.behaviour.TrapdoorMovingInteraction;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.compat.create.FramedBlockEntityItemRequirement;
import xfacthd.framedblocks.api.compat.create.FramedBlockSafeNbtWriter;
import xfacthd.framedblocks.api.util.registration.DeferredBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.compat.create.FramedBlockMovementChecks;
import xfacthd.framedblocks.common.compat.create.schematic.nbt.FramedChiseledBookshelfSafeNbtWriter;
import xfacthd.framedblocks.common.compat.create.schematic.nbt.FramedItemFrameSafeNbtWriter;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedDoorBlockItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedFlowerPotBlockEntityItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedItemFrameBlockEntityItemRequirement;
import xfacthd.framedblocks.common.compat.create.schematic.requirements.FramedSpecialDoubleBlockItemRequirements;
import xfacthd.framedblocks.common.compat.create.schematic.state.FramedChiseledBookshelfStateFilter;

public final class CreateCompat {
    private static final boolean REGISTER_CT_PROPERTY = false;

    public static void init() {
        if (ModList.get().isLoaded("create")) {
            try {
                if (FMLEnvironment.dist.isClient()) {
                    GuardedClientAccess.init();
                }
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing client-only Create integration!", e);
            }
        }
    }

    public static void commonSetup() {
        if (ModList.get().isLoaded("create")) {
            try {
                GuardedAccess.init();
            }
            catch (Throwable e) {
                FramedBlocks.LOGGER.warn("An error occured while initializing Create integration!", e);
            }
        }
    }

    private CreateCompat() {
    }

    private static final class GuardedClientAccess {
        private GuardedClientAccess() {
        }

        public static void init() {
        }
    }

    private static final class GuardedAccess {
        private static final Map<Holder<BlockEntityType<?>>, SchematicRequirementRegistries.BlockEntityRequirement> SPECIAL_REQUIREMENT_BLOCK_ENTITIES = Map.of(FBContent.BE_TYPE_FRAMED_FLOWER_POT, new FramedFlowerPotBlockEntityItemRequirement(), FBContent.BE_TYPE_FRAMED_ITEM_FRAME, new FramedItemFrameBlockEntityItemRequirement());
        private static final Map<Holder<BlockEntityType<?>>, SafeNbtWriterRegistry.SafeNbtWriter> SPECIAL_NBT_BLOCK_ENTITIES = Map.of(FBContent.BE_TYPE_FRAMED_CHEST, new FramedBlockSafeNbtWriter("inventory", "overflow"), FBContent.BE_TYPE_FRAMED_SECRET_STORAGE, new FramedBlockSafeNbtWriter("inventory", "overflow"), FBContent.BE_TYPE_FRAMED_TANK, new FramedBlockSafeNbtWriter("fluid"), FBContent.BE_TYPE_FRAMED_ITEM_FRAME, new FramedItemFrameSafeNbtWriter(), FBContent.BE_TYPE_FRAMED_CHISELED_BOOKSHELF, new FramedChiseledBookshelfSafeNbtWriter(), FBContent.BE_TYPE_FRAMED_HOPPER, new FramedBlockSafeNbtWriter("Items", "TransferCooldown"));

        private GuardedAccess() {
        }

        public static void init() {
            try {
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_LEVER, (MovingInteractionBehaviour)new LeverMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_DOOR, (MovingInteractionBehaviour)new DoorMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_TRAP_DOOR, (MovingInteractionBehaviour)new TrapdoorMovingInteraction());
                GuardedAccess.registerInteractionBehaviour(FBContent.BLOCK_FRAMED_FENCE_GATE, (MovingInteractionBehaviour)new FenceGateMovingInteraction());
            }
            catch (Throwable t) {
                FramedBlocks.LOGGER.warn("An error occured while registering MovingInteractions for Create contraptions!", t);
            }
            FramedBlockMovementChecks movementChecks = new FramedBlockMovementChecks();
            BlockMovementChecks.registerMovementNecessaryCheck((BlockMovementChecks.MovementNecessaryCheck)movementChecks);
            BlockMovementChecks.registerMovementAllowedCheck((BlockMovementChecks.MovementAllowedCheck)movementChecks);
            BlockMovementChecks.registerBrittleCheck((BlockMovementChecks.BrittleCheck)movementChecks);
            BlockMovementChecks.registerAttachedCheck((BlockMovementChecks.AttachedCheck)movementChecks);
            BlockMovementChecks.registerNotSupportiveCheck((BlockMovementChecks.NotSupportiveCheck)movementChecks);
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOUBLE_SLAB, new FramedSpecialDoubleBlockItemRequirements(FBContent.BLOCK_FRAMED_SLAB));
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOUBLE_PANEL, new FramedSpecialDoubleBlockItemRequirements(FBContent.BLOCK_FRAMED_PANEL));
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_DOOR, FramedDoorBlockItemRequirement.INSTANCE);
            GuardedAccess.registerBlockItemRequirement(FBContent.BLOCK_FRAMED_IRON_DOOR, FramedDoorBlockItemRequirement.INSTANCE);
            for (DeferredBlockEntity<? extends FramedBlockEntity> blockEntity : FBContent.getBlockEntities()) {
                GuardedAccess.registerBlockEntityItemRequirement(blockEntity, SPECIAL_REQUIREMENT_BLOCK_ENTITIES.getOrDefault(blockEntity, FramedBlockEntityItemRequirement.INSTANCE));
                GuardedAccess.registerSafeNbtWriter(blockEntity, SPECIAL_NBT_BLOCK_ENTITIES.getOrDefault(blockEntity, FramedBlockSafeNbtWriter.INSTANCE));
            }
            GuardedAccess.registerStateFilter(FBContent.BLOCK_FRAMED_CHISELED_BOOKSHELF, new FramedChiseledBookshelfStateFilter());
        }

        private static void registerInteractionBehaviour(Holder<Block> block, MovingInteractionBehaviour behaviour) {
            MovingInteractionBehaviour.REGISTRY.register((Object)((Block)block.value()), (Object)behaviour);
        }

        private static void registerBlockItemRequirement(Holder<Block> type, SchematicRequirementRegistries.BlockRequirement itemRequirement) {
            SchematicRequirementRegistries.BLOCKS.register((Object)((Block)type.value()), (Object)itemRequirement);
        }

        private static void registerBlockEntityItemRequirement(Holder<BlockEntityType<?>> type, SchematicRequirementRegistries.BlockEntityRequirement itemRequirement) {
            SchematicRequirementRegistries.BLOCK_ENTITIES.register((Object)((BlockEntityType)type.value()), (Object)itemRequirement);
        }

        private static void registerSafeNbtWriter(Holder<BlockEntityType<?>> type, SafeNbtWriterRegistry.SafeNbtWriter writer) {
            SafeNbtWriterRegistry.REGISTRY.register((Object)((BlockEntityType)type.value()), (Object)writer);
        }

        private static void registerStateFilter(Holder<Block> block, SchematicStateFilterRegistry.StateFilter filter) {
            SchematicStateFilterRegistry.REGISTRY.register((Object)((Block)block.value()), (Object)filter);
        }
    }
}

