/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slopepanel;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatExtendedDoubleSlopePanelCornerBlockEntity
extends FramedDoubleBlockEntity {
    private final boolean isInner = this.getBlockType() == BlockType.FRAMED_FLAT_EXT_INNER_DOUBLE_SLOPE_PANEL_CORNER;

    public FramedFlatExtendedDoubleSlopePanelCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_FRAMED_FLAT_EXTENDED_DOUBLE_SLOPE_PANEL_CORNER.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        Direction facing;
        Direction side = hit.getDirection();
        if (side == (facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR))) {
            return false;
        }
        if (side == facing.getOpposite()) {
            return true;
        }
        HorizontalRotation rotation = (HorizontalRotation)((Object)this.getBlockState().getValue(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(facing);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(facing);
        if (this.isInner && (side == rotDir.getOpposite() || side == perpRotDir.getOpposite())) {
            return false;
        }
        Vec3 hitVec = hit.getLocation();
        double hor = Utils.fractionInDir(hitVec, facing.getOpposite());
        if (!(this.isInner || side != rotDir && side != perpRotDir)) {
            return hor > 0.5;
        }
        Direction perpDir = this.isInner ? (side == rotDir ? perpRotDir.getOpposite() : rotDir.getOpposite()) : (side == rotDir.getOpposite() ? perpRotDir.getOpposite() : rotDir.getOpposite());
        double perpHor = Utils.fractionInDir(hitVec, perpDir);
        return (hor - 0.5) * 2.0 > perpHor;
    }
}

