/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.FramedSignItem;

public class FramedStandingSignBlock
extends AbstractFramedSignBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public FramedStandingSignBlock() {
        super(BlockType.FRAMED_SIGN, BlockBehaviour.Properties::noCollission);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BlockStateProperties.ROTATION_16});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            int rotation = RotationSegment.convertToSegment((float)(modCtx.getRotation() + 180.0f));
            return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation));
        })).withWater()).build();
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction dir, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (dir == Direction.DOWN && !this.canSurvive(state, (LevelReader)level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, dir, facingState, level, pos, facingPos);
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return level.getBlockState(pos.below()).isSolid();
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        int rotation = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        rotation = rot == Rotation.COUNTERCLOCKWISE_90 ? (rotation += 15) : ++rotation;
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rotation % 16));
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        int rotation = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(rot.rotate(rotation, 16)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        int rot = (Integer)state.getValue((Property)BlockStateProperties.ROTATION_16);
        return (BlockState)state.setValue((Property)BlockStateProperties.ROTATION_16, (Comparable)Integer.valueOf(mirror.mirror(rot, 16)));
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return RotationSegment.convertToDegrees((int)((Integer)state.getValue((Property)BlockStateProperties.ROTATION_16)));
    }

    @Override
    public BlockItem createBlockItem() {
        return new FramedSignItem();
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

