/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedCompoundSlopePanelGeometry
extends Geometry {
    private final Direction dir;
    private final HorizontalRotation rot;
    private final Direction orientation;
    private final Direction.Axis triangleAxis;
    private final boolean ySlope;

    public FramedCompoundSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.rot = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.orientation = this.rot.withFacing(this.dir);
        this.triangleAxis = this.rot.rotate(Rotation.CLOCKWISE_90).withFacing(this.dir).getAxis();
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.orientation) {
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.orientation.getOpposite()) {
            if (Utils.isY(quadDir)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.5f)).export(quadMap.get(quadDir));
            }
        } else if (quadDir == this.dir) {
            if (!Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(this.rot == HorizontalRotation.LEFT, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(this.rot == HorizontalRotation.DOWN, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
            }
        } else if (quadDir == this.dir.getOpposite()) {
            if (!Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(Modifiers.makeHorizontalSlope(this.rot == HorizontalRotation.LEFT, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.makeVerticalSlope(this.rot == HorizontalRotation.UP, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
            }
        } else if (this.triangleAxis == Direction.Axis.Y && Utils.isY(quadDir)) {
            boolean right = this.rot == HorizontalRotation.RIGHT;
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).export(quadMap.get(quadDir));
        } else if (this.triangleAxis != Direction.Axis.Y && quadDir.getAxis() == this.triangleAxis) {
            boolean up = this.rot == HorizontalRotation.UP;
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, up ? 1.0f : 0.5f, up ? 0.5f : 1.0f)).apply(Modifiers.cutSideLeftRight(this.dir.getOpposite(), up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

