/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.pane;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedPaneGeometry
extends Geometry {
    protected final boolean north;
    protected final boolean east;
    protected final boolean south;
    protected final boolean west;

    public FramedPaneGeometry(GeometryFactory.Context ctx) {
        this.north = (Boolean)ctx.state().getValue((Property)BlockStateProperties.NORTH);
        this.east = (Boolean)ctx.state().getValue((Property)BlockStateProperties.EAST);
        this.south = (Boolean)ctx.state().getValue((Property)BlockStateProperties.SOUTH);
        this.west = (Boolean)ctx.state().getValue((Property)BlockStateProperties.WEST);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        if (Utils.isY(face)) {
            if (this.isPillarVisible()) {
                FramedPaneGeometry.createTopBottomCenterQuad(quadMap, quad, false);
            }
            if (this.north) {
                FramedPaneGeometry.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
            }
            if (this.east) {
                FramedPaneGeometry.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
            }
            if (this.south) {
                FramedPaneGeometry.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
            }
            if (this.west) {
                FramedPaneGeometry.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
            }
        } else {
            boolean inset = this.isSideInset(face);
            if (!inset || this.isPillarVisible()) {
                FramedPaneGeometry.createSideEdgeQuad(quadMap, quad, inset, false);
            }
            if (Utils.isX(face)) {
                if (this.north) {
                    FramedPaneGeometry.createSideQuad(quadMap.get(null), quad, Direction.NORTH);
                }
                if (this.south) {
                    FramedPaneGeometry.createSideQuad(quadMap.get(null), quad, Direction.SOUTH);
                }
            }
            if (Utils.isZ(face)) {
                if (this.east) {
                    FramedPaneGeometry.createSideQuad(quadMap.get(null), quad, Direction.EAST);
                }
                if (this.west) {
                    FramedPaneGeometry.createSideQuad(quadMap.get(null), quad, Direction.WEST);
                }
            }
        }
    }

    protected boolean isPillarVisible() {
        return true;
    }

    protected static void createTopBottomCenterQuad(QuadMap quadMap, BakedQuad quad, boolean mirrored) {
        QuadModifier.of(quad).apply(Modifiers.cutTopBottom(0.4375f, 0.4375f, 0.5625f, 0.5625f)).applyIf(Modifiers.setPosition(0.001f), mirrored).export(quadMap.get(mirrored ? null : quad.getDirection()));
    }

    protected static void createTopBottomEdgeQuad(QuadMap quadMap, BakedQuad quad, Direction dir, boolean mirrored) {
        Preconditions.checkArgument((!Utils.isY(dir) ? 1 : 0) != 0, (Object)String.format("Invalid direction: %s!", dir));
        QuadModifier.of(quad).apply(Modifiers.cutTopBottom(dir.getOpposite(), 0.4375f)).apply(Modifiers.cutTopBottom(dir.getClockWise().getAxis(), 0.5625f)).applyIf(Modifiers.setPosition(0.001f), mirrored).export(quadMap.get(mirrored ? null : quad.getDirection()));
    }

    protected static void createSideEdgeQuad(QuadMap quadMap, BakedQuad quad, boolean inset, boolean mirrored) {
        Preconditions.checkArgument((!inset || !mirrored ? 1 : 0) != 0, (Object)"Quad can't be mirrored and inset!");
        Direction quadDir = quad.getDirection();
        Direction exportSide = inset ? null : (mirrored ? quadDir.getOpposite() : quadDir);
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(0.5625f)).applyIf(Modifiers.setPosition(0.5625f), inset).applyIf(Modifiers.setPosition(0.001f), !inset && mirrored).export(quadMap.get(exportSide));
    }

    private static void createSideQuad(List<BakedQuad> quadList, BakedQuad quad, Direction dir) {
        QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(dir.getOpposite(), 0.4375f)).apply(Modifiers.setPosition(0.5625f)).export(quadList);
    }

    protected boolean isSideInset(Direction face) {
        return switch (face) {
            case Direction.NORTH -> {
                if (!this.north) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (!this.east) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (!this.south) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (!this.west) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
        };
    }
}

