/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketUpdateCardInPlayer(ItemStack stack) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbuilder", (String)"updatecard_player");
    public static final CustomPacketPayload.Type<PacketUpdateCardInPlayer> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateCardInPlayer> CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, PacketUpdateCardInPlayer::stack, PacketUpdateCardInPlayer::new);

    public static PacketUpdateCardInPlayer create(ItemStack stack) {
        return new PacketUpdateCardInPlayer(stack);
    }

    private boolean isValidItem(ItemStack stack) {
        return stack.getItem() instanceof ShapeCardItem;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack heldItem = player.getItemInHand(InteractionHand.MAIN_HAND);
            if (heldItem.isEmpty()) {
                return;
            }
            if (this.isValidItem(heldItem) && this.isValidItem(this.stack)) {
                player.setItemInHand(InteractionHand.MAIN_HAND, this.stack);
            }
        });
    }
}

