/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public record TransmitterInfo(BlockPos coordinate, String name, TeleportDestination teleportDestination) {
    public static final Codec<TransmitterInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("coordinate").forGetter(info -> Optional.ofNullable(info.coordinate)), (App)Codec.STRING.fieldOf("name").forGetter(TransmitterInfo::getName), (App)TeleportDestination.CODEC.fieldOf("destination").forGetter(TransmitterInfo::getTeleportDestination)).apply((Applicative)instance, (pos, name, dest) -> new TransmitterInfo(pos.orElse(null), (String)name, (TeleportDestination)dest)));
    public static final StreamCodec<RegistryFriendlyByteBuf, TransmitterInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)BlockPos.STREAM_CODEC), d -> Optional.ofNullable(d.coordinate), (StreamCodec)ByteBufCodecs.STRING_UTF8, d -> d.name, TeleportDestination.STREAM_CODEC, d -> d.teleportDestination, (pos, name, dest) -> new TransmitterInfo(pos.orElse(null), (String)name, (TeleportDestination)dest));

    public TransmitterInfo(BlockPos coordinate, String name, TeleportDestination teleportDestination) {
        this.coordinate = coordinate;
        this.name = name;
        this.teleportDestination = teleportDestination == null ? new TeleportDestination(BlockPosTools.INVALID, (ResourceKey<Level>)Level.OVERWORLD) : teleportDestination;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public String getName() {
        return this.name;
    }

    public TeleportDestination getTeleportDestination() {
        return this.teleportDestination;
    }

    public static class Serializer
    implements ISerializer<TransmitterInfo> {
        public Function<RegistryFriendlyByteBuf, TransmitterInfo> getDeserializer() {
            return arg_0 -> STREAM_CODEC.decode(arg_0);
        }

        public BiConsumer<RegistryFriendlyByteBuf, TransmitterInfo> getSerializer() {
            return (arg_0, arg_1) -> STREAM_CODEC.encode(arg_0, arg_1);
        }
    }
}

