/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record MatterReceiverData(int id, String name, boolean privateAccess, Set<String> players) {
    public static final Codec<MatterReceiverData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(MatterReceiverData::id), (App)Codec.STRING.optionalFieldOf("name").forGetter(d -> Optional.ofNullable(d.name)), (App)Codec.BOOL.fieldOf("private").forGetter(MatterReceiverData::privateAccess), (App)Codec.list((Codec)Codec.STRING).fieldOf("players").forGetter(d -> new ArrayList<String>(d.players()))).apply((Applicative)instance, (id, name, priv, players) -> new MatterReceiverData((int)id, name.orElse(null), (boolean)priv, (Set<String>)new HashSet<String>((Collection<String>)players))));
    public static final StreamCodec<RegistryFriendlyByteBuf, MatterReceiverData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, d -> d.id, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), d -> Optional.ofNullable(d.name), (StreamCodec)ByteBufCodecs.BOOL, d -> d.privateAccess, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs.list()), d -> new ArrayList<String>(d.players), (id, name, priv, players) -> new MatterReceiverData((int)id, name.orElse(null), (boolean)priv, (Set<String>)new HashSet<String>((Collection<String>)players)));

    public static MatterReceiverData createDefault() {
        return new MatterReceiverData(-1, null, false, Collections.emptySet());
    }

    public MatterReceiverData withId(int id) {
        return new MatterReceiverData(id, this.name, this.privateAccess, this.players);
    }

    public MatterReceiverData withShowFav(boolean showFav) {
        return new MatterReceiverData(this.id, this.name, showFav, this.players);
    }

    public MatterReceiverData withName(String name) {
        return new MatterReceiverData(this.id, name, this.privateAccess, this.players);
    }

    public MatterReceiverData withPlayers(Set<String> players) {
        return new MatterReceiverData(this.id, this.name, this.privateAccess, players);
    }

    public MatterReceiverData addPlayer(String player) {
        HashSet<String> newPlayers = new HashSet<String>(this.players);
        newPlayers.add(player);
        return new MatterReceiverData(this.id, this.name, this.privateAccess, newPlayers);
    }

    public MatterReceiverData removePlayer(String player) {
        HashSet<String> newPlayers = new HashSet<String>(this.players);
        newPlayers.remove(player);
        return new MatterReceiverData(this.id, this.name, this.privateAccess, newPlayers);
    }
}

