/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.client;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.GuiTools;
import mcjty.lib.gui.BaseScreen;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.ComponentFactory;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinationClientInfo;
import mcjty.rftoolsutility.modules.teleporter.network.PacketGetAllReceivers;
import mcjty.rftoolsutility.setup.CommandHandler;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class GuiTeleportProbe
extends BaseScreen {
    private final int xSize = 356;
    private final int ySize = 180;
    private Window window;
    private WidgetList list;
    private static List<TeleportDestinationClientInfo> serverDestinationList = null;
    private static List<TeleportDestinationClientInfo> destinationList = null;
    private int listDirty = 0;

    public GuiTeleportProbe() {
        super((Component)ComponentFactory.literal((String)"Teleport Probe"));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        super.init();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.list = ((WidgetList)new WidgetList().name("list")).event((SelectionEvent)new DefaultSelectionEvent(){

            public void doubleClick(int index) {
                GuiTeleportProbe.this.teleport(index);
            }
        });
        Slider listSlider = ((Slider)new Slider().desiredWidth(11)).vertical().scrollableName("list");
        Panel toplevel = (Panel)Widgets.horizontal((int)3, (int)1).children(new Widget[]{this.list, listSlider});
        toplevel.bounds(k, l, 356, 180);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        serverDestinationList = null;
        destinationList = null;
        this.requestReceiversFromServer();
    }

    private void teleport(int index) {
        TeleportDestinationClientInfo destination = destinationList.get(index);
        BlockPos c = destination.destination().getCoordinate();
        RFToolsUtilityMessages.sendToServer("forceTeleport", TypedMap.builder().put(CommandHandler.PARAM_DIMENSION, (Object)destination.destination().getDimension().location().toString()).put(CommandHandler.PARAM_POS, (Object)c));
    }

    public static void setReceivers(List<TeleportDestinationClientInfo> destinationList) {
        serverDestinationList = new ArrayList<TeleportDestinationClientInfo>(destinationList);
    }

    private void requestReceiversFromServer() {
        RFToolsUtilityMessages.sendToServer(new PacketGetAllReceivers());
    }

    private void populateList() {
        if (serverDestinationList == null) {
            return;
        }
        if (serverDestinationList.equals(destinationList)) {
            return;
        }
        destinationList = new ArrayList<TeleportDestinationClientInfo>(serverDestinationList);
        this.list.removeChildren();
        for (TeleportDestinationClientInfo destination : destinationList) {
            BlockPos coordinate = destination.destination().getCoordinate();
            ResourceKey<Level> dim = destination.destination().getDimension();
            Panel panel = Widgets.horizontal();
            panel.children(new Widget[]{((Label)((Label)Widgets.label((String)destination.destination().getName()).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(100), ((Label)((Label)Widgets.label((String)BlockPosTools.toString((BlockPos)coordinate)).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(75), ((Label)((Label)Widgets.label((String)("Id " + String.valueOf(dim))).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(75)});
            this.list.children(new Widget[]{panel});
        }
    }

    protected void renderInternal(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.populateList();
            this.listDirty = 10;
        }
        this.window.draw(graphics);
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int x = GuiTools.getRelativeX((Screen)this);
            int y = GuiTools.getRelativeY((Screen)this);
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            List properties = tooltips.stream().map(ComponentFactory::literal).collect(Collectors.toList());
            List processors = Language.getInstance().getVisualOrder(properties);
            graphics.renderTooltip(Minecraft.getInstance().font, processors, x - guiLeft, y - guiTop);
        }
    }

    public static void open() {
        Minecraft.getInstance().setScreen((Screen)new GuiTeleportProbe());
    }
}

