/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class DestinationAnalyzerBlock
extends Block {
    public DestinationAnalyzerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2.0f, 6.0f));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Player placer = context.getPlayer();
        return (BlockState)super.getStateForPlacement(context).setValue((Property)BlockStateProperties.FACING, (Comparable)DestinationAnalyzerBlock.getFacingFromEntity(pos, (LivingEntity)placer));
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity entityIn) {
        if (Mth.abs((float)((float)entityIn.getX() - (float)clickedBlock.getX())) < 2.0f && Mth.abs((float)((float)entityIn.getZ() - (float)clickedBlock.getZ())) < 2.0f) {
            double d0 = entityIn.getY() + (double)entityIn.getEyeHeight();
            if (d0 - (double)clickedBlock.getY() > 2.0) {
                return Direction.UP;
            }
            if ((double)clickedBlock.getY() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.getDirection().getOpposite();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.FACING});
    }
}

