/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import mcjty.lib.network.NetworkTools;
import mcjty.lib.varia.Logging;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;

public enum ScreenDataType {
    TYPE_NULL,
    TYPE_BYTE,
    TYPE_INT,
    TYPE_LONG,
    TYPE_DOUBLE,
    TYPE_FLOAT,
    TYPE_STRING,
    TYPE_BOOLEAN,
    TYPE_ITEMSTACK,
    TYPE_COLOREDTEXT;


    public Object readObject(RegistryFriendlyByteBuf buf) {
        switch (this.ordinal()) {
            case 0: {
                return null;
            }
            case 1: {
                return buf.readByte();
            }
            case 2: {
                return buf.readInt();
            }
            case 3: {
                return buf.readLong();
            }
            case 4: {
                return buf.readDouble();
            }
            case 5: {
                return Float.valueOf(buf.readFloat());
            }
            case 7: {
                return buf.readBoolean();
            }
            case 6: {
                return buf.readUtf(Short.MAX_VALUE);
            }
            case 8: {
                return NetworkTools.readItemStack((RegistryFriendlyByteBuf)buf);
            }
            case 9: {
                return null;
            }
        }
        return null;
    }

    public static void writeObject(RegistryFriendlyByteBuf buf, Object obj) {
        if (obj == null) {
            buf.writeByte(TYPE_NULL.ordinal());
        } else if (obj instanceof Long) {
            buf.writeByte(TYPE_LONG.ordinal());
            buf.writeLong(((Long)obj).longValue());
        } else if (obj instanceof Integer) {
            buf.writeByte(TYPE_INT.ordinal());
            buf.writeInt(((Integer)obj).intValue());
        } else if (obj instanceof Byte) {
            buf.writeByte(TYPE_BYTE.ordinal());
            buf.writeByte(((Byte)obj).byteValue());
        } else if (obj instanceof Float) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeFloat(((Float)obj).floatValue());
        } else if (obj instanceof Double) {
            buf.writeByte(TYPE_FLOAT.ordinal());
            buf.writeDouble(((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            buf.writeByte(TYPE_BOOLEAN.ordinal());
            buf.writeBoolean(((Boolean)obj).booleanValue());
        } else if (obj instanceof String) {
            buf.writeByte(TYPE_STRING.ordinal());
            String s = (String)obj;
            buf.writeInt(s.length());
            buf.writeBytes(s.getBytes());
        } else if (obj instanceof ItemStack) {
            buf.writeByte(TYPE_ITEMSTACK.ordinal());
            NetworkTools.writeItemStack((RegistryFriendlyByteBuf)buf, (ItemStack)((ItemStack)obj));
        } else {
            Logging.log((String)"Weird ScreenDataType!");
        }
    }
}

