/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CapabilityTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.BarMode;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.FluidBarScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.FluidBarClientScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class FluidModuleItem
extends GenericModuleItem
implements IComponentsToPreserve {
    public FluidModuleItem() {
        super(RFToolsUtility.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return FluidBarScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return FluidBarScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)ScreenModule.MODULE_FLUIDBAR_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return FluidBarScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new FluidBarClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.FLUID_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)FluidModuleItem.data(stack).getPos().pos());
    }

    protected String getInfoString(ItemStack stack) {
        FluidBarScreenModule data = FluidModuleItem.data(stack);
        return ModuleTools.getTargetString((String)data.getMonitor(), (GlobalPos)data.getPos());
    }

    public String getModuleName() {
        return "Fluid";
    }

    public static FluidBarScreenModule data(ItemStack stack) {
        FluidBarScreenModule data = (FluidBarScreenModule)stack.get(ScreenModule.MODULE_FLUIDBAR_DATA);
        if (data == null) {
            data = FluidBarScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<FluidBarScreenModule, FluidBarScreenModule> setter) {
        FluidBarScreenModule data = FluidModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(ScreenModule.MODULE_FLUIDBAR_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text((stack, s) -> FluidModuleItem.data(stack).withLine((String)s), stack -> FluidModuleItem.data(stack).getLine(), new String[]{"Label text"}).color((stack, c) -> FluidModuleItem.data(stack).withColor((int)c), stack -> FluidModuleItem.data(stack).getColor(), new String[]{"Color for the label"}).nl().label("mb+:").color((stack, c) -> FluidModuleItem.data(stack).withPosColor((int)c), stack -> FluidModuleItem.data(stack).getPosColor(), new String[]{"Color for the mb text"}).label("mb-:").color((stack, c) -> FluidModuleItem.data(stack).withNegColor((int)c), stack -> FluidModuleItem.data(stack).getNegColor(), new String[]{"Color for the negative", "mb/tick ratio"}).nl().toggleNegative((stack, b) -> FluidModuleItem.data(stack).withHideBar((boolean)b), stack -> FluidModuleItem.data(stack).isHideBar(), "Bar", new String[]{"Toggle visibility of the", "fluid bar"}).mode((stack, m) -> FluidModuleItem.data(stack).withBarMode((BarMode)m), stack -> FluidModuleItem.data(stack).getBarMode(), "mb").format((stack, f) -> FluidModuleItem.data(stack).withFormat((FormatStyle)f), stack -> FluidModuleItem.data(stack).getFormat()).nl().choices((stack, c) -> FluidModuleItem.data(stack, d -> d.withAlign(TextAlign.get((String)c))), stack -> FluidModuleItem.data(stack).getAlign().getSerializedName(), "Label alignment", new String[]{"Left", "Center", "Right"}).nl().label("Block:").block(stack -> FluidModuleItem.data(stack).getPos(), stack -> FluidModuleItem.data(stack).getMonitor()).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Player player = context.getPlayer();
        BlockEntity te = world.getBlockEntity(pos);
        FluidBarScreenModule data = FluidModuleItem.data(stack);
        if (CapabilityTools.getFluidCapabilitySafe((BlockEntity)te) != null) {
            data = data.withPos(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
            String name = "<invalid>";
            if (!world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            data = data.withMonitor(name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Fluid module is set to block '" + name + "'"));
            }
        } else {
            data = data.withPos(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID));
            data = data.withMonitor("");
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Fluid module is cleared");
            }
        }
        stack.set(ScreenModule.MODULE_FLUIDBAR_DATA, (Object)data);
        return InteractionResult.SUCCESS;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)ScreenModule.MODULE_FLUIDBAR_DATA.get());
    }
}

