/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.client.RenderSettings;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class EnvironmentalRenderer
implements BlockEntityRenderer<EnvironmentalControllerTileEntity> {
    public static final ResourceLocation HALO = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"block/effects/floatingsphere");
    private static final Random random = new Random();
    private static final List<EnvironmentalControllerTileEntity> toRender = new ArrayList<EnvironmentalControllerTileEntity>();
    private static final RenderSettings RENDER_SETTINGS = RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build();

    public EnvironmentalRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EnvironmentalControllerTileEntity te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            toRender.add(te);
        }
    }

    public static void register() {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)EnvironmentalModule.ENVIRONENTAL_CONTROLLER.be().get()), EnvironmentalRenderer::new);
    }

    public static void renderEnvironmentals(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (toRender.isEmpty()) {
            return;
        }
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        matrixStack.pushPose();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        for (EnvironmentalControllerTileEntity te : toRender) {
            float s = 0.6f + random.nextFloat() * 0.1f;
            matrixStack.pushPose();
            matrixStack.translate((float)te.getBlockPos().getX(), (float)te.getBlockPos().getY(), (float)te.getBlockPos().getZ());
            RenderHelper.renderBillboardQuadBright((PoseStack)matrixStack, (MultiBufferSource)buffer, (float)s, (ResourceLocation)HALO, (RenderSettings)RenderSettings.builder().color(255, 255, 255).renderType(CustomRenderTypes.TRANSLUCENT_LIGHTNING_NOLIGHTMAPS).alpha(128).build());
            matrixStack.popPose();
        }
        matrixStack.popPose();
        toRender.clear();
    }
}

