/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.magmator;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import owmii.powah.api.PowahAPI;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.magmator.MagmatorBlock;
import owmii.powah.lib.block.AbstractEnergyProvider;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.block.ITankHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.fluid.Tank;
import owmii.powah.util.Util;

public class MagmatorTile
extends AbstractEnergyProvider<MagmatorBlock>
implements IInventoryHolder,
ITankHolder {
    protected final Energy buffer = Energy.create(0L);
    protected boolean burning;

    public MagmatorTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.MAGMATOR.get(), pos, state, variant);
        ((Tank)this.tank.setCapacity(Util.bucketAmount() * 4).setValidator(stack -> PowahAPI.getMagmaticFluidEnergyProduced(stack.getFluid()) != 0)).setChange(() -> this.sync(10));
        this.inv.add(1);
    }

    public MagmatorTile(BlockPos pos, BlockState state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.readSync(nbt, registries);
        this.energy.read(nbt, "energy_buffer", true, false);
        this.burning = nbt.getBoolean("burning");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        this.energy.write(nbt, "energy_buffer", true, false);
        nbt.putBoolean("burning", this.burning);
        return super.writeSync(nbt, registries);
    }

    @Override
    protected int postTick(Level world) {
        if (!this.isRemote() && this.checkRedstone()) {
            long min;
            FluidStack fluid;
            int energyProduced;
            boolean flag = false;
            if (this.buffer.isEmpty() && !this.tank.isEmpty() && (energyProduced = PowahAPI.getMagmaticFluidEnergyProduced((fluid = this.tank.getFluid()).getFluid())) > 0) {
                int amountPerDrain = 100;
                int minStored = Math.min(this.tank.getFluidAmount(), amountPerDrain);
                this.buffer.setStored((long)minStored * (long)energyProduced / (long)amountPerDrain);
                this.buffer.setCapacity((long)minStored * (long)energyProduced / (long)amountPerDrain);
                this.tank.drain(minStored, IFluidHandler.FluidAction.EXECUTE);
            }
            if ((min = Math.min(this.getGeneration(), this.buffer.getStored())) > 0L && this.energy.getEmpty() >= min) {
                this.energy.produce(min);
                this.buffer.consume(min);
                flag = true;
                this.sync(4);
            }
            if (this.burning != flag) {
                this.burning = flag;
                this.sync(4);
            }
        }
        return this.chargeItems(1) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public Tank getTank() {
        return this.tank;
    }

    @Override
    public boolean keepEnergy() {
        return true;
    }

    @Override
    public boolean keepFluid() {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return true;
    }

    public boolean isBurning() {
        return this.burning;
    }
}

