/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.client.renderer.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import cy.jdkdigital.chromacarvings.common.entity.ColoredSnowGolem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ColoredSnowGolemHeadLayer
extends RenderLayer<ColoredSnowGolem, SnowGolemModel<ColoredSnowGolem>> {
    private final BlockRenderDispatcher blockRenderer;
    private final ItemRenderer itemRenderer;

    public ColoredSnowGolemHeadLayer(RenderLayerParent<ColoredSnowGolem, SnowGolemModel<ColoredSnowGolem>> renderer, BlockRenderDispatcher blockRenderer, ItemRenderer itemRenderer) {
        super(renderer);
        this.blockRenderer = blockRenderer;
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, ColoredSnowGolem golem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (golem.hasPumpkin()) {
            boolean flag;
            boolean bl = flag = Minecraft.getInstance().shouldEntityAppearGlowing((Entity)golem) && golem.isInvisible();
            if (!golem.isInvisible() || flag) {
                poseStack.pushPose();
                ((SnowGolemModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
                poseStack.translate(0.0f, -0.34375f, 0.0f);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                poseStack.scale(0.625f, -0.625f, -0.625f);
                ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)golem.getType()).withPath(p -> p.replace("snow_golem", "carved_pumpkin"))));
                if (flag) {
                    BlockState blockstate = Blocks.CARVED_PUMPKIN.defaultBlockState();
                    BakedModel bakedmodel = this.blockRenderer.getBlockModel(blockstate);
                    int i = LivingEntityRenderer.getOverlayCoords((LivingEntity)golem, (float)0.0f);
                    poseStack.translate(-0.5f, -0.5f, -0.5f);
                    this.blockRenderer.getModelRenderer().renderModel(poseStack.last(), buffer.getBuffer(RenderType.outline((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), blockstate, bakedmodel, 0.0f, 0.0f, 0.0f, packedLight, i);
                } else {
                    this.itemRenderer.renderStatic((LivingEntity)golem, itemstack, ItemDisplayContext.HEAD, false, poseStack, buffer, golem.level(), packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)golem, (float)0.0f), golem.getId());
                }
                poseStack.popPose();
            }
        }
    }
}

