/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.blockentity;

import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.init.ModBlockEntities;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TrophyBlockEntity
extends BlockEntity {
    public static final Map<Integer, Entity> cachedEntities = new HashMap<Integer, Entity>();
    public String trophyType = "item";
    public ItemStack item = null;
    public CompoundTag entity = null;
    public double offsetY = 0.0;
    public float rotX = 0.0f;
    public float scale = 1.0f;
    public ResourceLocation baseBlock;
    public boolean isOnHead = false;
    private String name = "";

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.TROPHY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.loadData(pTag.getCompound("TrophyData"), pRegistries);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        CompoundTag trophyTag = new CompoundTag();
        trophyTag.putString("TrophyType", this.trophyType);
        if (this.item != null) {
            trophyTag.put("TrophyItem", this.item.save(pRegistries, (Tag)new CompoundTag()));
        }
        if (this.entity != null) {
            trophyTag.put("TrophyEntity", (Tag)this.entity);
        }
        trophyTag.putDouble("OffsetY", this.offsetY);
        trophyTag.putFloat("RotX", this.rotX);
        trophyTag.putFloat("Scale", this.scale);
        if (this.baseBlock != null) {
            trophyTag.putString("BaseBlock", this.baseBlock.toString());
        }
        if (this.name != null) {
            trophyTag.putString("Name", this.name);
        }
        pTag.put("TrophyData", (Tag)trophyTag);
    }

    public void loadData(CompoundTag tag, HolderLookup.Provider pRegistries) {
        String string = this.trophyType = tag.contains("TrophyType") ? tag.getString("TrophyType") : "item";
        if (tag.contains("TrophyItem")) {
            CompoundTag itemTag = tag.getCompound("TrophyItem");
            if (!itemTag.contains("Count")) {
                itemTag.putDouble("Count", 1.0);
            }
            this.item = ItemStack.parse((HolderLookup.Provider)pRegistries, (Tag)itemTag).orElse(ItemStack.EMPTY);
        } else if (this.trophyType.equals("item")) {
            this.item = new ItemStack((ItemLike)Items.ENCHANTED_GOLDEN_APPLE);
        }
        if (tag.contains("TrophyEntity")) {
            this.entity = tag.getCompound("TrophyEntity");
        }
        this.scale = tag.contains("Scale") ? tag.getFloat("Scale") : ((Double)TrophyManagerConfig.GENERAL.defaultScale.get()).floatValue();
        this.rotX = tag.contains("RotX") ? tag.getFloat("RotX") : 0.0f;
        this.offsetY = tag.contains("OffsetY") ? tag.getDouble("OffsetY") : ((Double)TrophyManagerConfig.GENERAL.defaultYOffset.get()).doubleValue();
        this.baseBlock = tag.contains("BaseBlock") ? ResourceLocation.parse((String)tag.getString("BaseBlock")) : ResourceLocation.parse((String)((String)TrophyManagerConfig.GENERAL.defaultBaseBlock.get()));
        if (tag.contains("Name")) {
            this.name = tag.getString("Name");
        }
    }

    public Entity getCachedEntity() {
        if (this.entity != null) {
            int key = this.entity.hashCode();
            if (!cachedEntities.containsKey(key)) {
                Entity cachedEntity = TrophyBlockEntity.createEntity(this.level, this.entity);
                if (cachedEntity != null) {
                    if (cachedEntity instanceof NeutralMob && this.entity.contains("AngerTime")) {
                        ((NeutralMob)cachedEntity).setRemainingPersistentAngerTime(this.entity.getInt("AngerTime"));
                    }
                    try {
                        TrophyBlockEntity.addPassengers(cachedEntity, this.entity);
                    }
                    catch (Exception exception) {}
                } else {
                    TrophyManager.LOGGER.info("Unable to create trophy entity " + String.valueOf(this.entity));
                }
                try {
                    TrophyBlockEntity.addPassengers(cachedEntity, this.entity);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                cachedEntities.put(key, cachedEntity);
            }
            return cachedEntities.getOrDefault(key, null);
        }
        return null;
    }

    private static Entity createEntity(Level level, CompoundTag tag) {
        return TrophyBlockEntity.createEntity(level, tag.getString("entityType"), tag);
    }

    private static Entity createEntity(Level level, String entityType, CompoundTag tag) {
        EntityType type = EntityType.byString((String)entityType).orElse(null);
        if (type != null) {
            try {
                Entity loadedEntity = type.create(level);
                if (loadedEntity != null) {
                    loadedEntity.load(tag);
                    return loadedEntity;
                }
            }
            catch (Exception e) {
                TrophyManager.LOGGER.warn("Unable to load trophy entity " + entityType + ". Please report it to the mod author at https://github.com/JDKDigital/trophymanager/issues");
                TrophyManager.LOGGER.warn("Error: " + e.getMessage());
                TrophyManager.LOGGER.warn("Tag: " + String.valueOf(tag));
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private static void addPassengers(Entity vehicle, CompoundTag entityTag) {
        if (entityTag.contains("Passengers")) {
            ListTag passengers = entityTag.getList("Passengers", 10);
            for (int l = 0; l < passengers.size(); ++l) {
                CompoundTag riderTag = passengers.getCompound(l);
                Entity rider = TrophyBlockEntity.createEntity(vehicle.level(), riderTag.getString("id"), riderTag);
                if (rider == null) continue;
                rider.startRiding(vehicle);
                TrophyBlockEntity.addPassengers(rider, riderTag);
            }
        }
    }

    public Block getBaseBlock() {
        return (Block)BuiltInRegistries.BLOCK.get(this.baseBlock);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithoutMetadata(lookupProvider);
    }

    public ItemInteractionResult equipArmor(ItemStack heldItem) {
        if (!this.canEquip(this.getCachedEntity()) || this.level == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ListTag armorList = this.entity.contains("ArmorItems") ? this.entity.getList("ArmorItems", 10) : new ListTag();
        NonNullList armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int l = 0; l < armorItems.size(); ++l) {
            armorItems.set(l, (Object)ItemStack.parse((HolderLookup.Provider)this.level.registryAccess(), (Tag)armorList.getCompound(l)).orElse(ItemStack.EMPTY));
        }
        Item armorItem = heldItem.getItem();
        if (armorItem instanceof ArmorItem) {
            int slot = ((ArmorItem)armorItem).getEquipmentSlot().getIndex();
            if (((ItemStack)armorItems.get(slot)).getItem().equals(armorItem)) {
                armorItems.set(slot, (Object)ItemStack.EMPTY);
            } else {
                armorItems.set(slot, (Object)heldItem);
            }
        }
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : armorItems) {
            CompoundTag compoundnbt = new CompoundTag();
            if (!itemstack.isEmpty()) {
                itemstack.save((HolderLookup.Provider)this.level.registryAccess(), (Tag)compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        this.entity.put("ArmorItems", (Tag)listnbt);
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return ItemInteractionResult.CONSUME;
    }

    public ItemInteractionResult equipTool(ItemStack heldItem) {
        int slot;
        if (!this.canEquip(this.getCachedEntity()) || this.level == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ListTag handList = this.entity.contains("HandItems") ? this.entity.getList("HandItems", 10) : new ListTag();
        NonNullList handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        for (int l = 0; l < handItems.size(); ++l) {
            handItems.set(l, (Object)ItemStack.parse((HolderLookup.Provider)this.level.registryAccess(), (Tag)handList.getCompound(l)).orElse(ItemStack.EMPTY));
        }
        int n = slot = heldItem.getItem() instanceof ShieldItem ? 1 : 0;
        if (((ItemStack)handItems.get(slot)).getItem().equals(heldItem.getItem())) {
            handItems.set(slot, (Object)ItemStack.EMPTY);
        } else {
            handItems.set(slot, (Object)heldItem);
        }
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : handItems) {
            CompoundTag compoundnbt = new CompoundTag();
            if (!itemstack.isEmpty()) {
                itemstack.save((HolderLookup.Provider)this.level.registryAccess(), (Tag)compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        this.entity.put("HandItems", (Tag)listnbt);
        if (this.level instanceof ServerLevel) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return ItemInteractionResult.CONSUME;
    }

    private boolean canEquip(Entity cachedEntity) {
        return cachedEntity instanceof Mob || cachedEntity instanceof ArmorStand;
    }
}

