/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.trophymanager.common.block;

import com.mojang.serialization.MapCodec;
import cy.jdkdigital.trophymanager.TrophyManager;
import cy.jdkdigital.trophymanager.TrophyManagerConfig;
import cy.jdkdigital.trophymanager.common.blockentity.TrophyBlockEntity;
import cy.jdkdigital.trophymanager.common.datamap.NbtMap;
import cy.jdkdigital.trophymanager.common.datamap.PropertiesMap;
import cy.jdkdigital.trophymanager.init.ModBlocks;
import cy.jdkdigital.trophymanager.init.ModTags;
import cy.jdkdigital.trophymanager.network.PacketOpenGui;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class TrophyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrophyBlock> CODEC = TrophyBlock.simpleCodec(TrophyBlock::new);
    protected static final VoxelShape SLAB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.9, (double)16.0);

    public TrophyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public boolean useShapeForLightOcclusion(@Nonnull BlockState state) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{BlockStateProperties.WATERLOGGED}).add(new Property[]{HorizontalDirectionalBlock.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public VoxelShape getShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SLAB;
    }

    public RenderShape getRenderShape(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState pState, PathComputationType pPathComputationType) {
        return false;
    }

    public void setPlacedBy(Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity player, @Nonnull ItemStack stack) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (!level.isClientSide() && tileEntity instanceof TrophyBlockEntity && stack.has(DataComponents.CUSTOM_DATA)) {
            ((TrophyBlockEntity)tileEntity).loadData(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag(), (HolderLookup.Provider)level.registryAccess());
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        TrophyBlockEntity trophyTile;
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TrophyBlockEntity && (trophyTile = (TrophyBlockEntity)blockEntity).getLevel() != null) {
            try {
                CompoundTag tag = trophyTile.saveWithoutMetadata((HolderLookup.Provider)trophyTile.getLevel().registryAccess());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag.getCompound("TrophyData")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return stack;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        ItemInteractionResult res;
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        Block heldBlock;
        if (pStack.getItem() instanceof BlockItem && (heldBlock = ((BlockItem)pStack.getItem()).getBlock()).defaultBlockState().is(ModTags.TROPHY_BASE) && (blockEntity2 = pLevel.getBlockEntity(pPos)) instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)blockEntity2).baseBlock = BuiltInRegistries.BLOCK.getKey((Object)heldBlock);
            if (!pLevel.isClientSide()) {
                pLevel.setBlockAndUpdate(pPos, pState);
            }
            return ItemInteractionResult.CONSUME;
        }
        if (pStack.getItem() instanceof ArmorItem && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof TrophyBlockEntity) {
            res = ((TrophyBlockEntity)blockEntity).equipArmor(pStack);
            if (!pLevel.isClientSide() && res.equals((Object)ItemInteractionResult.CONSUME)) {
                pLevel.setBlockAndUpdate(pPos, pState);
            }
            return res;
        }
        if ((pStack.getItem() instanceof TieredItem || pStack.getItem() instanceof ShieldItem) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof TrophyBlockEntity) {
            res = ((TrophyBlockEntity)blockEntity).equipTool(pStack);
            if (!pLevel.isClientSide() && res.equals((Object)ItemInteractionResult.CONSUME)) {
                pLevel.setBlockAndUpdate(pPos, pState);
            }
            return res;
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if ((((Boolean)TrophyManagerConfig.GENERAL.allowNonOpEdit.get()).booleanValue() || pPlayer.hasPermissions(2)) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof TrophyBlockEntity) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PacketOpenGui(blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean condition) {
        BlockEntity te;
        if (!level.isClientSide && level.hasNeighborSignal(pos) && (te = level.getBlockEntity(pos)) instanceof TrophyBlockEntity && ((TrophyBlockEntity)te).trophyType.equals("entity")) {
            String entity;
            switch (entity = ((TrophyBlockEntity)te).entity.getString("entityType")) {
                case "minecraft:creeper": {
                    level.playSound(null, pos, SoundEvents.CREEPER_PRIMED, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:iron_golem": {
                    level.playSound(null, pos, SoundEvents.IRON_GOLEM_DAMAGE, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:snow_golem": {
                    level.playSound(null, pos, SoundEvents.SNOW_GOLEM_SHOOT, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ender_dragon": {
                    level.playSound(null, pos, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:bee": {
                    level.playSound(null, pos, SoundEvents.BEEHIVE_WORK, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:hoglin": {
                    level.playSound(null, pos, SoundEvents.HOGLIN_ANGRY, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:zoglin": {
                    level.playSound(null, pos, SoundEvents.ZOGLIN_ANGRY, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:slime": {
                    level.playSound(null, pos, SoundEvents.SLIME_SQUISH, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:turtle": {
                    level.playSound(null, pos, SoundEvents.TURTLE_AMBIENT_LAND, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:llama": 
                case "minecraft:trader_llama": {
                    if (level.random.nextInt(10) == 1) {
                        level.playSound(null, pos, SoundEvents.LLAMA_SPIT, SoundSource.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                }
                case "minecraft:tropical_fish": 
                case "minecraft:pufferfish": {
                    level.playSound(null, pos, SoundEvents.GENERIC_SPLASH, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:ghast": {
                    if (level.random.nextInt(10) == 1) {
                        level.playSound(null, pos, SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 1.0f, 1.0f);
                        break;
                    }
                    level.playSound(null, pos, SoundEvents.GHAST_WARN, SoundSource.HOSTILE, 1.0f, 1.0f);
                    break;
                }
                case "minecraft:goat": {
                    if (level.random.nextInt(2) == 1) {
                        level.playSound(null, pos, SoundEvents.GOAT_SCREAMING_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                        break;
                    }
                    level.playSound(null, pos, SoundEvents.GOAT_AMBIENT, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    break;
                }
                default: {
                    SoundEvent sound;
                    Entity e = ((TrophyBlockEntity)te).getCachedEntity();
                    if (!(e instanceof Mob) || (sound = ((Mob)e).getAmbientSound()) == null) break;
                    level.playSound(null, pos, sound, SoundSource.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    public static ItemStack createPlayerTrophy(Player player) {
        CompoundTag trophyTag = new CompoundTag();
        ItemStack trophy = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        trophyTag.putString("TrophyType", "entity");
        CompoundTag entityTag = new CompoundTag();
        entityTag.putString("entityType", "trophymanager:player");
        entityTag.putString("uuid", player.getUUID().toString());
        trophyTag.putString("Name", player.getDisplayName().getString() + " Trophy");
        trophyTag.put("TrophyEntity", (Tag)entityTag);
        trophy.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)trophyTag));
        return trophy;
    }

    public static ItemStack createTrophy(Entity entity, CompoundTag tag) {
        Component name = entity.getDisplayName();
        return TrophyBlock.createTrophy(entity.getType().builtInRegistryHolder(), tag, name.getString());
    }

    public static ItemStack createTrophy(Holder<EntityType<?>> entityType, CompoundTag tag, String name) {
        PropertiesMap defaultProperties;
        String entityId = entityType.getKey().location().toString();
        if (entityId == null || entityId.isEmpty()) {
            return ItemStack.EMPTY;
        }
        CompoundTag entityTag = new CompoundTag();
        NbtMap data = (NbtMap)entityType.getData(TrophyManager.NBT_MAP);
        if (data != null) {
            data.nbtKeys().forEach(key -> {
                if (tag.contains(key)) {
                    entityTag.put(key, tag.get(key));
                }
            });
        }
        if (tag.contains("CustomName")) {
            entityTag.putString("CustomName", tag.getString("CustomName"));
        }
        CompoundTag trophyTag = new CompoundTag();
        ItemStack trophy = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        trophyTag.putString("TrophyType", "entity");
        entityTag.putString("entityType", entityId);
        if (tag.contains("Age") && tag.getInt("Age") < 0) {
            entityTag.putInt("Age", -1);
        }
        if ((defaultProperties = (PropertiesMap)entityType.getData(TrophyManager.PROPERTIES_MAP)) != null) {
            trophyTag.putFloat("Scale", defaultProperties.scale());
            trophyTag.putFloat("RotX", defaultProperties.rotX());
            trophyTag.putDouble("OffsetY", defaultProperties.yOffset());
        }
        trophyTag.put("TrophyEntity", (Tag)entityTag);
        trophyTag.putString("Name", name + " Trophy");
        trophy.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)trophyTag));
        return trophy;
    }

    public static ItemStack createTrophy(Level level, ItemStack stack, String name) {
        if (stack.isEmpty() || level == null) {
            return ItemStack.EMPTY;
        }
        CompoundTag trophyTag = new CompoundTag();
        ItemStack trophy = new ItemStack((ItemLike)ModBlocks.TROPHY.get());
        trophyTag.putString("TrophyType", "item");
        trophyTag.put("TrophyItem", stack.save((HolderLookup.Provider)level.registryAccess()));
        trophyTag.putString("Name", name + " Trophy");
        trophy.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)trophyTag));
        return trophy;
    }
}

