/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.gui.microchip.MicrochipMenu;
import net.swedz.little_big_redstone.gui.microchip.logic.DyeComponentResult;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.MicrochipObjectContainerType;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record DyeMicrochipObjectPacket(int containerId, MicrochipObjectContainerType containerType, int slot) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, DyeMicrochipObjectPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, DyeMicrochipObjectPacket::containerId, (StreamCodec)CodecHelper.forEnumStream(MicrochipObjectContainerType.class), DyeMicrochipObjectPacket::containerType, (StreamCodec)ByteBufCodecs.VAR_INT, DyeMicrochipObjectPacket::slot, DyeMicrochipObjectPacket::new);

    /*
     * Enabled aggressive block sorting
     */
    public void handle(PacketContext context) {
        AbstractContainerMenu abstractContainerMenu;
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof MicrochipMenu) {
            MicrochipMenu menu = (MicrochipMenu)abstractContainerMenu;
            if (menu.containerId == this.containerId) {
                Microchip microchip = menu.microchip();
                ItemStack heldItem = menu.getCarried();
                MicrochipObject entry = microchip.get(this.slot, this.containerType);
                if (entry == null) {
                    LBR.LOGGER.warn("Received DyeMicrochipObjectPacket from {} targetting mismatching or non-existent component (slot {})", (Object)playerName, (Object)this.slot);
                    return;
                }
                DyeComponentResult result = DyeComponentResult.test(heldItem, entry.color());
                if (result.success()) {
                    if (entry.setColor(result.color())) {
                        microchip.markDirty();
                        if (!result.consume()) return;
                        heldItem.consume(1, (LivingEntity)player);
                        return;
                    }
                    LBR.LOGGER.warn("Received DyeMicrochipObjectPacket from {} when the color of the entry remains unchanged, discarding", (Object)playerName);
                    return;
                }
                if (result.result() == DyeComponentResult.Result.WRONG_ITEM) {
                    LBR.LOGGER.warn("Received DyeMicrochipObjectPacket from {} while not carrying a dye or dye washing item in their cursor, discarding", (Object)playerName);
                    return;
                }
                if (result.result() != DyeComponentResult.Result.NO_CHANGE) return;
                LBR.LOGGER.warn("Received DyeMicrochipObjectPacket from {} when the color is already set to the clicked color", (Object)playerName);
                return;
            }
        }
        LBR.LOGGER.warn("Received DyeMicrochipObjectPacket from {} while not in a microchip menu (or in expired one?), discarding", (Object)playerName);
    }
}

