/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.sequencer;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicGridSize;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.sequencer.LogicSequencerConfig;
import net.swedz.little_big_redstone.microchip.object.logic.sequencer.LogicSequencerMode;

public final class LogicSequencer
extends LogicComponent<LogicSequencer, LogicSequencerConfig> {
    public static final MapCodec<LogicSequencer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LogicSequencerConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.LONG.optionalFieldOf("processed_ticks", (Object)1L).forGetter(LogicSequencer::processedTicks), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(LogicSequencer::output)).apply((Applicative)instance, LogicSequencer::new));
    public static final StreamCodec<ByteBuf, LogicSequencer> STREAM_CODEC = StreamCodec.composite(LogicSequencerConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.VAR_LONG, LogicSequencer::processedTicks, (StreamCodec)ByteBufCodecs.BOOL, LogicSequencer::output, LogicSequencer::new);
    private long processedTicks;
    private boolean outputState;

    private LogicSequencer(LogicSequencerConfig config, Optional<DyeColor> color, long processedTicks, boolean outputState) {
        super(config, color);
        this.processedTicks = processedTicks;
        this.outputState = outputState;
    }

    private LogicSequencer(Optional<DyeColor> color, long processedTicks, boolean outputState) {
        super(color);
        this.processedTicks = processedTicks;
        this.outputState = outputState;
    }

    public LogicSequencer() {
        this(Optional.empty(), 0L, false);
    }

    @Override
    protected LogicSequencerConfig defaultConfig() {
        return new LogicSequencerConfig();
    }

    public long processedTicks() {
        return this.processedTicks;
    }

    public float processedPercentage() {
        return Math.min((float)this.processedTicks / (float)((LogicSequencerConfig)this.config).outputDelay, 1.0f);
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        long originalProcessedTicks = this.processedTicks;
        boolean originalOutputState = this.outputState;
        boolean input = inputs[0];
        boolean output = false;
        if (((LogicSequencerConfig)this.config).resetPort && inputs[1]) {
            this.processedTicks = 0L;
        } else if (input) {
            ++this.processedTicks;
        } else if (this.processedTicks > 0L) {
            if (((LogicSequencerConfig)this.config).mode == LogicSequencerMode.WEAK) {
                ++this.processedTicks;
            } else if (((LogicSequencerConfig)this.config).mode == LogicSequencerMode.STRONG) {
                --this.processedTicks;
            }
        }
        if (this.processedTicks >= ((LogicSequencerConfig)this.config).outputDelay) {
            this.processedTicks = ((LogicSequencerConfig)this.config).autoReset ? 0L : ((LogicSequencerConfig)this.config).outputDelay;
            output = true;
        }
        this.outputState = output;
        if (originalProcessedTicks != this.processedTicks || output != originalOutputState) {
            context.markDirty(this);
        }
    }

    @Override
    public LogicType<LogicSequencer> type() {
        return LogicTypes.SEQUENCER;
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public LogicGridSize size() {
        return new LogicGridSize(2, 1);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_SEQUENCER_1));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_SEQUENCER_2));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_HELP_SEQUENCER_3));
    }

    @Override
    protected void internalLoadFrom(LogicSequencer other) {
        this.processedTicks = other.processedTicks;
        this.outputState = other.outputState;
    }

    @Override
    public void internalResetForPickup() {
        this.processedTicks = 0L;
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type(), this.config, this.color, this.processedTicks});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicSequencer)) return false;
        LogicSequencer other = (LogicSequencer)o;
        if (!Objects.equal((Object)this.config, (Object)other.config)) return false;
        if (!Objects.equal((Object)this.color, (Object)other.color)) return false;
        if (this.processedTicks != other.processedTicks) return false;
        return true;
    }
}

