/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.reader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;

public final class LogicReaderConfig
extends LogicConfig<LogicReaderConfig> {
    public static final MapCodec<LogicReaderConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecHelper.forLowercaseEnum(LogicReaderMode.class).optionalFieldOf("mode", (Object)LogicReaderMode.ITEM).forGetter(config -> config.mode), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.NORTH).forGetter(config -> config.direction), (App)Codec.FLOAT.optionalFieldOf("fill_threshold", (Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.fillThreshold)), (App)CodecHelper.forLowercaseEnum(LogicComparisonMode.class).optionalFieldOf("comparison", (Object)LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO).forGetter(config -> config.comparison)).apply((Applicative)instance, LogicReaderConfig::new));
    public static final StreamCodec<ByteBuf, LogicReaderConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forLowercaseEnumStream(LogicReaderMode.class), config -> config.mode, (StreamCodec)Direction.STREAM_CODEC, config -> config.direction, (StreamCodec)ByteBufCodecs.FLOAT, config -> Float.valueOf(config.fillThreshold), (StreamCodec)CodecHelper.forEnumStream(LogicComparisonMode.class), config -> config.comparison, LogicReaderConfig::new);
    public LogicReaderMode mode;
    public Direction direction;
    public float fillThreshold;
    public LogicComparisonMode comparison;

    private LogicReaderConfig(LogicReaderMode mode, Direction direction, float fillThreshold, LogicComparisonMode comparison) {
        this.mode = mode;
        this.direction = direction;
        this.fillThreshold = fillThreshold;
        this.comparison = comparison;
    }

    public LogicReaderConfig() {
        this(LogicReaderMode.ITEM, Direction.NORTH, 0.5f, LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO);
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(0, 0);
    }

    @Override
    public int inputs() {
        return 0;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int outputs() {
        return 1;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_MODE).arg((Object)this.mode, (Parser)LBRTooltips.READER_MODE_PARSER));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_DIRECTION).arg(this.direction, (Parser)LBRTooltips.DIRECTION_PARSER));
        lines.add((Component)LBRTextLine.line(LBRText.LOGIC_CONFIG_TOOLTIP_READER_FILL).arg(this.comparison, Float.valueOf(this.fillThreshold), (BiParser)LBRTooltips.COMPARISON_PERCENTAGE_PARSER));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    private LBRText comparisonTooltip() {
        return switch (this.comparison) {
            default -> throw new MatchException(null, null);
            case LogicComparisonMode.LESS_THAN_OR_EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_THRESHOLD_COMPARISON_MODE_LESS_THAN_OR_EQUAL_TO;
            case LogicComparisonMode.EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_THRESHOLD_COMPARISON_MODE_EQUAL_TO;
            case LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO -> LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_THRESHOLD_COMPARISON_MODE_GREATER_THAN_OR_EQUAL_TO;
        };
    }

    @Override
    public void buildMenu(LogicConfigMenuBuilder builder, int width, int height) {
        AtomicReference<LogicConfigButtonReference<LogicComparisonMode>> comparisonButton = new AtomicReference<LogicConfigButtonReference<LogicComparisonMode>>();
        Runnable updateComparisonButtonTooltip = () -> {
            LogicConfigButtonReference button = (LogicConfigButtonReference)comparisonButton.get();
            if (button != null) {
                button.setTooltip((Component)this.comparisonTooltip().arg(Float.valueOf(this.fillThreshold), 0, Parser.FLOAT_PERCENTAGE));
            }
        };
        builder.addCycleButton((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_MODE.text(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_MODE.text(), 0, 0, width, 18, false, this.mode, Arrays.asList(LogicReaderMode.values()), value -> LBRTooltips.READER_MODE_PARSER.parse((Object)value).plainCopy(), value -> {
            this.mode = value;
        });
        builder.addCycleButton((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_DIRECTION.text(), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_DIRECTION.text(), 0, 22, width, 18, false, this.direction, Arrays.asList(Direction.values()), arg_0 -> LBRTooltips.DIRECTION_PARSER.parse(arg_0), value -> {
            this.direction = value;
        });
        builder.addSlider((Component)LBRText.LOGIC_CONFIG_BUTTON_LABEL_READER_FILL_THRESHOLD.text(), (Component)Component.literal((String)"%"), (Component)LBRText.LOGIC_CONFIG_BUTTON_TOOLTIP_READER_FILL_THRESHOLD.text(), 22, 44, width - 18 - 4, 18, 0.0, 100.0, this.fillThreshold * 100.0f, 1.0, 0, value -> {
            this.fillThreshold = (float)(value / 100.0);
            updateComparisonButtonTooltip.run();
        });
        comparisonButton.set(builder.addCycleButton((Component)this.comparisonTooltip().arg(Float.valueOf(this.fillThreshold), 0, Parser.FLOAT_PERCENTAGE), 0, 44, LBR.id("textures/gui/slot_atlas.png"), this.comparison, Arrays.asList(LogicComparisonMode.values()), value -> {
            this.comparison = value;
            updateComparisonButtonTooltip.run();
        }));
        updateComparisonButtonTooltip.run();
    }

    @Override
    protected void internalLoadFrom(LogicReaderConfig other) {
        this.mode = other.mode;
        this.direction = other.direction;
        this.fillThreshold = other.fillThreshold;
        this.comparison = other.comparison;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.direction, Float.valueOf(this.fillThreshold), this.comparison});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicReaderConfig)) return false;
        LogicReaderConfig other = (LogicReaderConfig)o;
        if (this.mode != other.mode) return false;
        if (this.direction != other.direction) return false;
        if (this.fillThreshold != other.fillThreshold) return false;
        if (this.comparison != other.comparison) return false;
        return true;
    }
}

