/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig.button.iconcycle;

import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.swedz.little_big_redstone.gui.logicconfig.button.LogicConfigButtonHelper;
import net.swedz.little_big_redstone.gui.logicconfig.button.iconcycle.IconCycleLogicConfigButtonIcon;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public class IconCycleLogicConfigButton<T extends IconCycleLogicConfigButtonIcon>
extends AbstractButton
implements LogicConfigButtonHelper {
    private final int color;
    private final ResourceLocation atlas;
    private final List<T> allowedValues;
    private final OnValueChange<T> onValueChange;
    private int valueIndex;
    private T value;

    public IconCycleLogicConfigButton(int x, int y, int color, ResourceLocation atlas, T initialValue, List<T> allowedValues, OnValueChange<T> onValueChange) {
        super(x, y, 18, 18, (Component)Component.empty());
        this.color = color;
        this.atlas = atlas;
        this.allowedValues = Collections.unmodifiableList(allowedValues);
        this.onValueChange = onValueChange;
        this.setValue(initialValue);
    }

    public T value() {
        return this.value;
    }

    public void setValue(T value) {
        int index = this.allowedValues.indexOf(value);
        if (index == -1) {
            throw new IllegalArgumentException("Button does not support value " + String.valueOf(value));
        }
        this.valueIndex = index;
        this.value = value;
        this.onValueChange.onValueChange(this, value);
    }

    private void next() {
        this.valueIndex = (this.valueIndex + 1) % this.allowedValues.size();
        this.value = (IconCycleLogicConfigButtonIcon)this.allowedValues.get(this.valueIndex);
        this.onValueChange.onValueChange(this, this.value);
    }

    public void onPress() {
        this.next();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected void renderWidget(GuiGraphics internal, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
        this.renderBackground(graphics, partialTick, this.getX(), this.getY(), this.width, this.height, this.color, this.active && this.isHoveredOrFocused());
        this.renderBorder(graphics, this.getX(), this.getY(), this.width, this.height, this.color);
        graphics.setTexture(this.atlas);
        graphics.setColor(this.color);
        int u = this.value.u();
        int v = this.value.v();
        if (!this.active) {
            v += this.height * 2;
        } else if (this.isHoveredOrFocused()) {
            v += this.height;
        }
        graphics.blit(this.getX(), this.getY(), u, v, this.width, this.height);
        graphics.resetColor();
    }

    public static interface OnValueChange<T extends IconCycleLogicConfigButtonIcon> {
        public void onValueChange(IconCycleLogicConfigButton var1, T var2);
    }
}

