/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.floppydisk;

import com.mojang.serialization.DynamicOps;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLPaths;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.network.packet.FloppyDiskLoadPacket;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.gui.widget.AutoFillEditBox;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class FloppyDiskScreen
extends Screen {
    private final InteractionHand hand;
    private int leftPos;
    private int topPos;
    private int uiWidth;
    private int uiHeight;
    private List<String> existingFiles = List.of();
    private AutoFillEditBox input;
    private Button save;
    private Button load;

    public FloppyDiskScreen(InteractionHand hand) {
        super((Component)LBRText.FLOPPY_DISK.text());
        this.hand = hand;
        this.uiWidth = 180;
        this.uiHeight = 214;
    }

    protected void init() {
        this.leftPos = this.width / 2 - this.uiWidth / 2;
        this.topPos = this.height / 2 - this.uiHeight / 2;
        this.existingFiles = FloppyDiskScreen.getExistingFiles();
        ItemStack stack = this.minecraft.player.getItemInHand(this.hand);
        boolean hasData = stack.has(LBRComponents.FLOPPY_DISK);
        boolean hasInput = this.input != null && !this.input.getValue().isEmpty();
        this.save = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)LBRText.FLOPPY_DISK_BUTTON_SAVE.text(), b -> this.save()).bounds(this.leftPos, this.topPos + this.uiHeight - 40 - 3, this.uiWidth / 2 - 3, 20).build());
        this.save.active = hasData && hasInput;
        this.load = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)LBRText.FLOPPY_DISK_BUTTON_LOAD.text(), b -> this.load()).bounds(this.leftPos + this.uiWidth / 2 + 3, this.topPos + this.uiHeight - 40 - 3, this.uiWidth / 2 - 3, 20).build());
        this.load.active = hasInput;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)LBRText.FLOPPY_DISK_BUTTON_CLOSE.text(), b -> this.close()).bounds(this.leftPos, this.topPos + this.uiHeight - 20, this.uiWidth, 20).build());
        this.input = new AutoFillEditBox(this.minecraft.font, this.leftPos, this.topPos + this.uiHeight / 2 - 20, this.uiWidth, 20, (Component)Component.empty(), () -> this.existingFiles, 3);
        this.input.setMaxLength(32);
        this.input.setFilter(s -> s.matches("[a-zA-Z0-9_]*"));
        this.input.setResponder(s -> {
            this.load.active = this.existingFiles.contains(s);
            if (hasData) {
                this.save.active = !s.isEmpty();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.input);
    }

    private static boolean isValidItem(ItemStack stack) {
        return !stack.isEmpty() && stack.is(LBRTags.Items.FLOPPY_DISKS);
    }

    private static Path path() {
        return FMLPaths.GAMEDIR.get().resolve("little_big_redstone").resolve("microchips");
    }

    private static Path path(String name) throws IOException {
        Assert.notNull((Object)name);
        Path folder = FloppyDiskScreen.path();
        Files.createDirectories(folder, new FileAttribute[0]);
        return FileUtil.createPathToResource((Path)folder, (String)name, (String)".snbt");
    }

    private static List<String> getExistingFiles() {
        List<String> list;
        block9: {
            Path path = FloppyDiskScreen.path();
            if (!Files.exists(path, new LinkOption[0])) {
                return List.of();
            }
            Stream<Path> files = Files.list(path);
            try {
                list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".snbt")).map(p -> {
                    String fileName = p.getFileName().toString();
                    return fileName.substring(0, fileName.lastIndexOf(46));
                }).toList();
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    LBR.LOGGER.warn("Failed to read files", (Throwable)ex);
                    return List.of();
                }
            }
            files.close();
        }
        return list;
    }

    private static boolean saveToFile(String name, Microchip.Immutable microchip) {
        try {
            Path path = FloppyDiskScreen.path(name);
            Tag tag = (Tag)Microchip.Immutable.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)microchip).getOrThrow();
            try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
                outputStream.write(new SnbtPrinterTagVisitor().visit(tag).getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }
        catch (Exception ex) {
            LBR.LOGGER.error("Failed to save microchip {} to file", (Object)name, (Object)ex);
            return false;
        }
    }

    private static boolean fileExists(String name) {
        try {
            return Files.exists(FloppyDiskScreen.path(name), new LinkOption[0]);
        }
        catch (IOException ex) {
            LBR.LOGGER.error("Failed to build microchip directory", (Throwable)ex);
            return false;
        }
    }

    private static Optional<Microchip.Immutable> loadFromFile(String name) {
        block7: {
            Optional<Microchip.Immutable> optional;
            Path path = FloppyDiskScreen.path(name);
            if (!Files.exists(path, new LinkOption[0])) break block7;
            FastBufferedInputStream inputStream = new FastBufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                CompoundTag tag = TagParser.parseTag((String)new String(inputStream.readAllBytes(), StandardCharsets.UTF_8));
                Microchip.Immutable microchip = (Microchip.Immutable)Microchip.Immutable.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
                optional = Optional.of(microchip);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LBR.LOGGER.error("Failed to read microchip {} from file", (Object)name, (Object)ex);
                }
            }
            inputStream.close();
            return optional;
        }
        return Optional.empty();
    }

    private void close() {
        this.minecraft.setScreen(null);
    }

    private void save() {
        this.close();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = player.getItemInHand(this.hand);
        if (!FloppyDiskScreen.isValidItem(stack)) {
            LBR.LOGGER.warn("Failed to save floppy disk because it is no longer in hand or is missing data.");
            return;
        }
        Microchip.Immutable microchip = (Microchip.Immutable)stack.get(LBRComponents.FLOPPY_DISK);
        String name = this.input.getValue();
        if (name.isEmpty()) {
            return;
        }
        if (FloppyDiskScreen.saveToFile(name, microchip)) {
            player.sendSystemMessage((Component)LBRText.FLOPPY_DISK_FILE_SAVED.text(new Object[]{name}).withStyle(ChatFormatting.GREEN));
        } else {
            player.sendSystemMessage((Component)LBRText.FLOPPY_DISK_FILE_FAILED_TO_SAVE.text().withStyle(ChatFormatting.RED));
        }
    }

    private void load() {
        this.close();
        LocalPlayer player = this.minecraft.player;
        ItemStack stack = player.getItemInHand(this.hand);
        if (!FloppyDiskScreen.isValidItem(stack)) {
            LBR.LOGGER.warn("Failed to load floppy disk because it is no longer in hand.");
            return;
        }
        String name = this.input.getValue();
        if (FloppyDiskScreen.fileExists(name)) {
            Optional<Microchip.Immutable> microchip = FloppyDiskScreen.loadFromFile(name);
            if (microchip.isPresent()) {
                new FloppyDiskLoadPacket(this.hand, name, microchip.get()).sendToServer();
            } else {
                player.sendSystemMessage((Component)LBRText.FLOPPY_DISK_FILE_FAILED_TO_LOAD.text().withStyle(ChatFormatting.RED));
            }
        } else {
            player.sendSystemMessage((Component)LBRText.FLOPPY_DISK_FILE_DOESNT_EXIST.text(new Object[]{name}).withStyle(ChatFormatting.RED));
        }
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.input);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String inputText = this.input.getValue();
        super.resize(minecraft, width, height);
        this.input.setValue(inputText);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        super.render(vanilla, mouseX, mouseY, partialTick);
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        graphics.drawString(this.title, this.leftPos + this.uiWidth / 2 - this.minecraft.font.width((FormattedText)this.title) / 2, this.topPos);
        MutableComponent mutableComponent = LBRText.FLOPPY_DISK_INPUT_PROGRAM_NAME.text();
        int n = this.input.getX();
        int n2 = this.input.getY();
        Objects.requireNonNull(this.minecraft.font);
        graphics.drawString((Component)mutableComponent, n, n2 - 9);
    }

    public void tick() {
        ItemStack stack = this.minecraft.player.getItemInHand(this.hand);
        if (!FloppyDiskScreen.isValidItem(stack)) {
            this.close();
        }
    }
}

