/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.LBRText;
import net.swedz.little_big_redstone.LBRTextLine;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;
import net.swedz.little_big_redstone.microchip.object.logic.selector.LogicSelectorMode;
import net.swedz.little_big_redstone.microchip.object.logic.sequencer.LogicSequencerMode;
import net.swedz.tesseract.neoforge.tooltip.BiParser;
import net.swedz.tesseract.neoforge.tooltip.Parser;
import net.swedz.tesseract.neoforge.tooltip.TooltipAttachment;

public final class LBRTooltips {
    public static final Style DEFAULT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)0xA9A9A9)).withItalic(Boolean.valueOf(false));
    public static final Style HIGHLIGHT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)16768637)).withItalic(Boolean.valueOf(false));
    public static final Style YES_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)0x7FFF7D)).withItalic(Boolean.valueOf(false));
    public static final Style NO_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)0xFF7D7F)).withItalic(Boolean.valueOf(false));
    public static final Style INPUT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)8232703)).withItalic(Boolean.valueOf(false));
    public static final Style OUTPUT_STYLE = Style.EMPTY.withColor(TextColor.fromRgb((int)16751997)).withItalic(Boolean.valueOf(false));
    public static final Parser<Boolean> INPUT_OUTPUT_PARSER = input -> input != false ? LBRText.INPUT.text().withStyle(INPUT_STYLE) : LBRText.OUTPUT.text().withStyle(OUTPUT_STYLE);
    public static final Parser<Direction> DIRECTION_PARSER = direction -> (switch (direction) {
        default -> throw new MatchException(null, null);
        case Direction.DOWN -> LBRText.DIRECTION_DOWN;
        case Direction.UP -> LBRText.DIRECTION_UP;
        case Direction.NORTH -> LBRText.DIRECTION_NORTH;
        case Direction.SOUTH -> LBRText.DIRECTION_SOUTH;
        case Direction.WEST -> LBRText.DIRECTION_WEST;
        case Direction.EAST -> LBRText.DIRECTION_EAST;
    }).text().withStyle(LBRTooltips.directionStyle(direction));
    public static final Parser<Boolean> BOOLEAN_YES_NO_PARSER = value -> value != false ? LBRText.YES.text().withStyle(YES_STYLE) : LBRText.NO.text().withStyle(NO_STYLE);
    public static final Parser<LogicReaderMode> READER_MODE_PARSER = value -> (switch (value) {
        default -> throw new MatchException(null, null);
        case LogicReaderMode.ITEM -> LBRText.CAPABILITY_ITEM;
        case LogicReaderMode.FLUID -> LBRText.CAPABILITY_FLUID;
        case LogicReaderMode.ENERGY -> LBRText.CAPABILITY_ENERGY;
    }).text().withStyle(HIGHLIGHT_STYLE);
    public static final Parser<LogicSequencerMode> SEQUENCER_MODE_PARSER = value -> value.label().text().withStyle(HIGHLIGHT_STYLE);
    public static final Parser<LogicSelectorMode> SELECTOR_MODE_PARSER = value -> value.label().text().withStyle(HIGHLIGHT_STYLE);
    public static final BiParser<LogicComparisonMode, Integer> COMPARISON_PARSER = (mode, value) -> Component.literal((String)"%s %s".formatted(mode.symbol(), value)).withStyle(HIGHLIGHT_STYLE);
    public static final BiParser<LogicComparisonMode, Float> COMPARISON_PERCENTAGE_PARSER = (mode, value) -> Component.literal((String)"%s %.0f%%".formatted(mode.symbol(), Float.valueOf(value.floatValue() * 100.0f))).withStyle(HIGHLIGHT_STYLE);
    public static final Parser<Long> TICKS_AND_SECONDS_PARSER = value -> LBRTooltips.ticksAndSecondsText(value).text(new Object[]{value, String.format("%.2f", Float.valueOf((float)value.longValue() / 20.0f))}).withStyle(HIGHLIGHT_STYLE);
    public static final BiParser<Double, String> TICKS_AND_SECONDS_SLIDER_PARSER = (value, string) -> LBRTooltips.ticksAndSecondsText(value).text(new Object[]{string, String.format("%.2f", value / 20.0)});
    public static final Parser<String> KEYBIND_PARSER = Parser.KEYBIND.withStyle(HIGHLIGHT_STYLE);
    public static final Parser<Object> DEFAULT_PARSER = value -> {
        Style style = DEFAULT_STYLE;
        if (value instanceof Integer || value instanceof Long || value instanceof Double || value instanceof Float) {
            style = HIGHLIGHT_STYLE;
        } else {
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return BOOLEAN_YES_NO_PARSER.parse((Object)bool);
            }
            if (value instanceof Component) {
                Component component = (Component)value;
                return component.copy().withStyle(style);
            }
        }
        return Component.literal((String)String.valueOf(value)).withStyle(style);
    };
    public static final TooltipAttachment LOGIC_GATE_NO_SHIFT = TooltipAttachment.multilinesOptional((stack, item) -> stack.has(LBRComponents.LOGIC), (flag, context, stack, item) -> {
        LogicComponent logicComponent = (LogicComponent)stack.get(LBRComponents.LOGIC);
        return logicComponent.type().tooltip(logicComponent, false, false);
    }).noShiftRequired();
    public static final TooltipAttachment LOGIC_GATE_SHIFT = TooltipAttachment.multilinesOptional((stack, item) -> stack.has(LBRComponents.LOGIC), (flag, context, stack, item) -> {
        LogicComponent logicComponent = (LogicComponent)stack.get(LBRComponents.LOGIC);
        return logicComponent.type().tooltip(logicComponent, true, true);
    });
    public static final TooltipAttachment LOGIC_ARRAY = TooltipAttachment.multilines((stack, item) -> stack.is(LBRTags.Items.LOGIC_ARRAYS), List.of(LBRTextLine.line(LBRText.LOGIC_ARRAY_HELP_1), LBRTextLine.line(LBRText.LOGIC_ARRAY_HELP_2), Component.empty(), LBRTextLine.line(LBRText.LOGIC_ARRAY_HELP_3).arg("use", (Parser)KEYBIND_PARSER), LBRTextLine.line(LBRText.LOGIC_ARRAY_HELP_4).arg("use", (Parser)KEYBIND_PARSER)));
    public static final TooltipAttachment FLOPPY_DISK = TooltipAttachment.multilines((stack, item) -> stack.is(LBRTags.Items.FLOPPY_DISKS), List.of(LBRTextLine.line(LBRText.FLOPPY_DISK_HELP_1), Component.empty(), LBRTextLine.line(LBRText.FLOPPY_DISK_HELP_2).arg("sneak", (Parser)KEYBIND_PARSER).arg("use", (Parser)KEYBIND_PARSER), LBRTextLine.line(LBRText.FLOPPY_DISK_HELP_3).arg("use", (Parser)KEYBIND_PARSER), LBRTextLine.line(LBRText.FLOPPY_DISK_HELP_4).arg("use", (Parser)KEYBIND_PARSER)));

    public static Style directionStyle(Direction direction) {
        return Style.EMPTY.withColor(TextColor.fromRgb((int)(switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> 16766976;
            case Direction.UP -> 0xFFFFFF;
            case Direction.NORTH -> 5046016;
            case Direction.SOUTH -> 38143;
            case Direction.WEST -> 16738816;
            case Direction.EAST -> 0xFF0000;
        }))).withItalic(Boolean.valueOf(false));
    }

    private static LBRText ticksAndSecondsText(Number value) {
        return value.intValue() != 1 ? LBRText.LOGIC_CONFIG_BUTTON_LABEL_TICKS_AND_SECONDS : LBRText.LOGIC_CONFIG_BUTTON_LABEL_TICKS_AND_SECONDS_SINGULAR;
    }

    public static void init() {
    }
}

