/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.common.containers;

import com.direwolf20.mininggadgets.common.containers.GhostSlot;
import com.direwolf20.mininggadgets.common.containers.handlers.DataComponentHandler;
import com.direwolf20.mininggadgets.common.items.MiningGadget;
import com.direwolf20.mininggadgets.common.items.UpgradeCard;
import com.direwolf20.mininggadgets.setup.Registration;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class FilterContainer
extends AbstractContainerMenu {
    public FilterContainer(int windowId, Inventory playerInventory, RegistryFriendlyByteBuf extraData) {
        this(windowId, playerInventory, new DataComponentHandler((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)extraData), 30));
    }

    public FilterContainer(int windowId, Inventory playerInventory, DataComponentHandler ghostInventory) {
        super((MenuType)Registration.FILTER_CONTAINER.get(), windowId);
        this.setup(new InvWrapper((Container)playerInventory), (IItemHandler)ghostInventory);
    }

    private void setup(InvWrapper playerInventory, IItemHandler ghostInventory) {
        int j;
        int i;
        int index = 0;
        int x = 8;
        int y = 143;
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)playerInventory, index, x + j * 18, y - (i > 0 ? 76 : 0) + i * 18));
                ++index;
            }
        }
        index = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot((Slot)new GhostSlot(ghostInventory, index, 8 + 18 * j, 18 + i * 18));
                ++index;
            }
        }
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            if (currentStack.getItem() instanceof MiningGadget || currentStack.getItem() instanceof UpgradeCard) {
                return itemstack;
            }
            if (currentStack.isEmpty()) {
                return itemstack;
            }
            int slotNumber = -1;
            for (int i = 36; i <= 62; ++i) {
                if (((Slot)this.slots.get(i)).getItem().isEmpty()) {
                    slotNumber = i;
                    break;
                }
                if (((Slot)this.slots.get(i)).getItem().getItem() == currentStack.getItem()) break;
            }
            if (slotNumber == -1) {
                return itemstack;
            }
            ((Slot)this.slots.get(slotNumber)).set(currentStack.copy().split(1));
        }
        return itemstack;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId < this.slots.size() && slotId >= 0 && ((Slot)this.slots.get(slotId)).getItem().getItem() instanceof MiningGadget || clickTypeIn == ClickType.SWAP) {
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }
}

