/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.mininggadgets.client.particles.playerparticle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class PlayerParticle
extends TextureSheetParticle {
    private double sourceX;
    private double sourceY;
    private double sourceZ;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int speedModifier;
    private String particleType;
    private Random rand = new Random();
    private int particlePicker;
    protected final SpriteSet spriteSet;
    public static final ResourceLocation iceParticle = ResourceLocation.parse((String)"mininggadgets:textures/particle/snowflake1.png");
    public static final ResourceLocation iceParticle2 = ResourceLocation.parse((String)"mininggadgets:textures/particle/snowflake2.png");
    public static final ResourceLocation iceParticle3 = ResourceLocation.parse((String)"mininggadgets:textures/particle/snowflake3.png");
    public static final ResourceLocation lightParticle = ResourceLocation.parse((String)"mininggadgets:textures/particle/lightparticle.png");

    public PlayerParticle(ClientLevel world, double sourceX, double sourceY, double sourceZ, double targetX, double targetY, double targetZ, double xSpeed, double ySpeed, double zSpeed, float size, float red, float green, float blue, boolean collide, float maxAge, String particleType, SpriteSet sprite) {
        super(world, sourceX, sourceY, sourceZ);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.rCol = red;
        this.gCol = green;
        this.bCol = blue;
        this.gravity = 0.0f;
        this.lifetime = Math.round(maxAge);
        this.setSize(0.001f, 0.001f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.quadSize = size;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.sourceZ = sourceZ;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetZ = targetZ;
        this.hasPhysics = collide;
        this.particleType = particleType;
        this.setGravity(0.0f);
        this.particlePicker = this.rand.nextInt(3) + 1;
        this.spriteSet = sprite;
        this.setSprite(sprite.get(this.particlePicker, 4));
    }

    public void render(VertexConsumer p_225606_1_, Camera p_225606_2_, float p_225606_3_) {
        super.render(p_225606_1_, p_225606_2_, p_225606_3_);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        Vec3 sourcePos = new Vec3(this.sourceX, this.sourceY, this.sourceZ);
        Vec3 targetPos = new Vec3(this.targetX, this.targetY, this.targetZ);
        Vec3 partPos = new Vec3(this.x, this.y, this.z);
        Vec3 targetDirection = new Vec3(targetPos.x() - this.x, targetPos.y() - this.y, targetPos.z() - this.z);
        double totalDistance = targetPos.distanceTo(partPos);
        if (totalDistance < 0.1) {
            this.remove();
        }
        double speedAdjust = 20.0;
        double moveX = (this.targetX - this.x) / speedAdjust;
        double moveY = (this.targetY - this.y) / speedAdjust;
        double moveZ = (this.targetZ - this.z) / speedAdjust;
        BlockPos nextPos = new BlockPos((int)this.x + (int)moveX, (int)this.y + (int)moveY, (int)this.z + (int)moveZ);
        if (this.age > 40) {
            this.hasPhysics = false;
        }
        this.move(moveX, moveY, moveZ);
    }

    public void setGravity(float value) {
        this.gravity = value;
    }

    public void setSpeed(float mx, float my, float mz) {
        this.xd = mx;
        this.yd = my;
        this.zd = mz;
    }
}

