/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.commoble.hyperbox.blocks.HyperboxBlockEntity;
import net.commoble.hyperbox.client.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class HyperboxBlockEntityRenderer
implements BlockEntityRenderer<HyperboxBlockEntity> {
    public HyperboxBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HyperboxBlockEntity hyperbox, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        Component customName = hyperbox.getCustomName();
        if (player != null && customName != null && HyperboxBlockEntityRenderer.shouldRenderNameplate(hyperbox, player)) {
            HyperboxBlockEntityRenderer.renderName(mc, hyperbox, customName, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    public static boolean shouldRenderNameplate(HyperboxBlockEntity hyperbox, LocalPlayer player) {
        double boxZ;
        double boxY;
        double radius = player.isCrouching() ? (Double)ClientProxy.clientConfig.nameplateSneakingRenderDistance.get() : (Double)ClientProxy.clientConfig.nameplateRenderDistance.get();
        if (radius <= 0.0) {
            return false;
        }
        BlockPos boxPos = hyperbox.getBlockPos();
        double boxX = (double)boxPos.getX() + 0.5;
        double distanceSquared = player.distanceToSqr(boxX, boxY = (double)boxPos.getY() + 0.5, boxZ = (double)boxPos.getZ() + 0.5);
        return distanceSquared < radius * radius;
    }

    public static void renderName(Minecraft mc, HyperboxBlockEntity hyperbox, Component displayNameIn, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Font fontRenderer = mc.font;
        Quaternionf cameraRotation = mc.getEntityRenderDispatcher().cameraOrientation();
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 1.4f, 0.5f);
        matrixStackIn.mulPose(cameraRotation);
        matrixStackIn.scale(-0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = matrixStackIn.last().pose();
        float backgroundOpacity = mc.options.getBackgroundOpacity(0.25f);
        int alpha = (int)(backgroundOpacity * 255.0f) << 24;
        float textOffset = -fontRenderer.width((FormattedText)displayNameIn) / 2;
        bufferIn = Minecraft.getInstance().renderBuffers().outlineBufferSource();
        fontRenderer.drawInBatch(displayNameIn, textOffset, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, Font.DisplayMode.SEE_THROUGH, alpha, 0xFFFFFF);
        fontRenderer.drawInBatch(displayNameIn, textOffset, 0.0f, -1, false, matrix4f, bufferIn, Font.DisplayMode.NORMAL, 0, 0xFFFFFF);
        matrixStackIn.popPose();
    }
}

