/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.thirdparty.fabricrendering;

import aztech.modern_industrialization.thirdparty.fabricrendering.EncodingFormat;
import aztech.modern_industrialization.thirdparty.fabricrendering.Mesh;
import aztech.modern_industrialization.thirdparty.fabricrendering.MutableQuadViewImpl;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadEmitter;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadView;
import aztech.modern_industrialization.thirdparty.fabricrendering.QuadViewImpl;
import java.util.function.Consumer;

public class MeshImpl
implements Mesh {
    ThreadLocal<QuadViewImpl> POOL = ThreadLocal.withInitial(QuadViewImpl::new);
    final int[] data;

    MeshImpl(int[] data) {
        this.data = data;
    }

    public int[] data() {
        return this.data;
    }

    @Override
    public void forEach(Consumer<QuadView> consumer) {
        this.forEach(consumer, this.POOL.get());
    }

    void forEach(Consumer<QuadView> consumer, QuadViewImpl cursor) {
        int limit = this.data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            cursor.load(this.data, index);
            consumer.accept(cursor);
        }
    }

    @Override
    public void outputTo(QuadEmitter emitter) {
        MutableQuadViewImpl e = (MutableQuadViewImpl)emitter;
        int[] data = this.data;
        int limit = data.length;
        for (int index = 0; index < limit; index += EncodingFormat.TOTAL_STRIDE) {
            System.arraycopy(data, index, e.data, e.baseIndex, EncodingFormat.TOTAL_STRIDE);
            e.load();
            e.emitDirectly();
        }
        e.clear();
    }
}

